/**
 * File: MyDefaultHandler.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.impl.CmdImpl;
import com.ibm.ims.connect.impl.CmdclientsImpl;
import com.ibm.ims.connect.impl.CmderrImpl;
import com.ibm.ims.connect.impl.CmdrspdataImpl;
import com.ibm.ims.connect.impl.CmdrsphdrImpl;
import com.ibm.ims.connect.impl.CmdsecerrImpl;
import com.ibm.ims.connect.impl.CtlImpl;
import com.ibm.ims.connect.impl.ExitImpl;
import com.ibm.ims.connect.impl.HdrImpl;
import com.ibm.ims.connect.impl.ImsoutImpl;
import com.ibm.ims.connect.impl.MbrImpl;
import com.ibm.ims.connect.impl.MsgdataImpl;
import com.ibm.ims.connect.impl.SafImpl;

import java.util.ArrayList;
import java.util.HashMap;
//import java.util.logging.*;
import java.util.Stack;
import java.util.Vector;


import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * @author kevin
 *
 */
public class MyDefaultHandler extends org.xml.sax.helpers.DefaultHandler
{
  //  private Logger logger; 
    private Type2CmdResponse myT2CmdRsp = null;
//    private byte numberOfRspElements = 0;
    Stack<String> qNameStack = new Stack<String>();
    String currentQName = null;
    int argHash = 0;
    boolean addNewHdrElement = true;
    boolean addNewMbrElement = true;
    boolean addNewMsgElement = true;
    boolean addNewRspElement = true;
/*    
    public void XmlParser(Type2CmdResponse aT2CmdRsp) 
    {
        logger = Logger.getLogger("com.ibm.ims.connect");
        myT2CmdRsp = aT2CmdRsp;
        numberOfRspElements = 0;
    }
*/    
    public void startElement(String uri, String localName, String qName, Attributes attributes)
        throws SAXException 
    {
//      System.out.println("Start Element :" + qName);
        currentQName = qName;
        qNameStack.push(currentQName);
        argHash = MyDefaultHandler.getHashValueFromString(currentQName.trim().toLowerCase());
        switch (argHash)
        {
            case 673: // imsout
                Imsout newImsout = myT2CmdRsp.getImsout();
                ((ImsoutImpl)newImsout).setElementText(new String(""));
                myT2CmdRsp.setImsout(newImsout);
                myT2CmdRsp.setImsOutElementBeingParsed(true);
                break;
                
            case 323: // ctl
                Ctl newCtl = myT2CmdRsp.getImsout().getCtl();
                if(newCtl == null)
                {
                    newCtl = new CtlImpl();
                    ((CtlImpl)newCtl).setCtlElementText("");
                    myT2CmdRsp.setCtl(newCtl);
                }
                myT2CmdRsp.setCtlElementBeingParsed(true);
                break;
                
            case 637: // omname or cmderr
                if ( qName.trim().toLowerCase().equals("omname") )
                {
                    myT2CmdRsp.setCtlOmnameElementBeingParsed(true);
                }
                else if ( qName.trim().toLowerCase().equals("cmderr") )
                {
                	 Cmderr newCmderr = myT2CmdRsp.getImsout().getCmderr();
                     if(newCmderr == null)
                     {
                    	 newCmderr = new CmderrImpl();
                         //((CmderrImpl)newCmderr).setCmderrElementText("");                         
                         ((ImsoutImpl)(myT2CmdRsp.getImsout())).setCmderr(newCmderr);
                     }
                    myT2CmdRsp.setCmderrElementBeingParsed(true);
                }
                break;
                
            case 563: // omvsn
                myT2CmdRsp.setCtlOmvsnElementBeingParsed(true);
                break;
                
            case 680: // xmlvsn
                myT2CmdRsp.setCtlXmlvsnElementBeingParsed(true);
                break;
                
            case 759: // statime
                myT2CmdRsp.setCtlStatimeElementBeingParsed(true);
                break;
                
            case 773: // stotime
                myT2CmdRsp.setCtlStotimeElementBeingParsed(true);
                break;
                
            case 657: // staseq
                myT2CmdRsp.setCtlStaseqElementBeingParsed(true);
                break;
                
            case 671: // stoseq
                myT2CmdRsp.setCtlStoseqElementBeingParsed(true);
                break;
                
            case 840: // rqsttkn1
                myT2CmdRsp.setCtlRqsttkn1ElementBeingParsed(true);
                break;
                
            case 841: // rqsttkn2
                myT2CmdRsp.setCtlRqsttkn2ElementBeingParsed(true);
                break;
                
            case 213: // rc ***** rc used as a sub-element of multiple elements (ctl, cmderr, cmdsecerrExit, cmdsecerrSaf) 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    myT2CmdRsp.setCtlRcElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmdsecerrExitElementBeingParsed())
                {
                    myT2CmdRsp.setCmdsecerrExitRcElementBeingParsed(true);
                }
                /*else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRcElementBeingParsed(true);
                }*/
                else if(myT2CmdRsp.isCmdsecerrSafElementBeingParsed())
                {
                    myT2CmdRsp.setCmdsecerrSafRcElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRcElementBeingParsed(true);
                }
                break;
                
            case 339: // rsn ***** rsn used as a sub-element of ctl and cmderr mbr's only 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    myT2CmdRsp.setCtlRsnElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRsnElementBeingParsed(true);
                }
                break;
                
            case 666: // rsnmsg
//                myT2CmdRsp.setXxxRsnmsgElementBeingParsed(true);  // is this tag even used???
            	//------------------------------------------------
            	if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    myT2CmdRsp.setCtlRsnmsgElementBeingParsed(true);
                }
            	//------------------------------------------------
                break;
                
            case 691: // rsntxt
//                myT2CmdRsp.setXxxRsntxtElementBeingParsed(true);  // is this tag even used???
            	//-------------------------------------------------
            	 if(myT2CmdRsp.isCtlElementBeingParsed())
                 {
                     myT2CmdRsp.setCtlRsntxtElementBeingParsed(true);
                 }
                 else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                 {
                     myT2CmdRsp.setCmderrMbrRsntxtBeingParsed(true);
                 }
            	 //-----------------------------------------------
                break;
                
            case 337: // uom
                myT2CmdRsp.setCtlUomElementBeingParsed(true);
                break;
                
            case 1062: // cmdclients
                myT2CmdRsp.setCmdclientsElementBeingParsed(true);
                break;
                
            case 321: // mbr ***** mbr used as a sub-element of multiple elements (cmdclients, cmderr and msgdata)
                if(myT2CmdRsp.isCmdclientsElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                	//--------------------------------------
                	ArrayList<Mbr> currentCmderrMbr = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    ArrayList<Mbr> newCmderrMbr = null;
                    int currentCmderrMbrLength;
                    if (currentCmderrMbr == null)
                    {
                        currentCmderrMbrLength = 0;
                        newCmderrMbr = new ArrayList<Mbr>();
                    }
                    else
                    {
                        currentCmderrMbrLength = currentCmderrMbr.size();
                       // newCmderrMbr = new ArrayList<Mbr>(currentCmderrMbrLength + 1);
                        newCmderrMbr = new ArrayList<Mbr>(currentCmderrMbr);
                       // if (currentCmderrMbrLength > 0)
                        //    System.arraycopy(currentCmderrMbr, 0, newCmderrMbr, 0, currentCmderrMbrLength);
                    }
                    
                    newCmderrMbr.add(new MbrImpl(attributes.getValue(0)));
                    ((CmderrImpl)(myT2CmdRsp.getImsout().getCmderr())).setMbr(newCmderrMbr);
                    
                    //---------------------------------------------------------------------------
                	myT2CmdRsp.setCmderrMbrElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isMsgdataElementBeingParsed())
                {
                    ArrayList<Mbr> currentMsgdataMbr = myT2CmdRsp.getImsout().getMsgdata().getMbr();
                    ArrayList<Mbr> newMsgdataMbr = null;
                    int currentMsgdataMbrLength;
                    if (currentMsgdataMbr == null)
                    {
                        currentMsgdataMbrLength = 0;
                        newMsgdataMbr = new ArrayList<Mbr>();
                    }
                    else
                    {
                       // currentMsgdataMbrLength = currentMsgdataMbr.size();
                       // newMsgdataMbr = new ArrayList<Mbr>(currentMsgdataMbrLength + 1);
                    	newMsgdataMbr = new ArrayList<Mbr>(currentMsgdataMbr);
                        //if (currentMsgdataMbrLength > 0)
                         //   System.arraycopy(currentMsgdataMbr, 0, newMsgdataMbr, 0, currentMsgdataMbrLength);
                    }
                    newMsgdataMbr.add(new MbrImpl(attributes.getValue(0)));
                    ((MsgdataImpl)(myT2CmdRsp.getImsout().getMsgdata())).setMbr(newMsgdataMbr);
                    myT2CmdRsp.setMsgdataMbrElementBeingParsed(true);
                }
                break;
                
            case 349: // typ  ***** typ used as a sub-element of multiple elements (cmdclientsMbr and cmderrMbr) 
                if(myT2CmdRsp.isCmdclientsMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrTypElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrTypElementBeingParsed(true);
                }
                break;
                
            case 464: // styp  ***** styp used as a sub-element of multiple elements (cmdclientsMbr and cmderrMbr) 
                if(myT2CmdRsp.isCmdclientsMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrStypElementBeingParsed(true);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrStypElementBeingParsed(true);
                }
                break;
                
            case 343: // vsn
                myT2CmdRsp.setCmdclientsMbrVsnElementBeingParsed(true);
                break;
                
            case 732: // jobname
                myT2CmdRsp.setCmdclientsMbrJobnameElementBeingParsed(true);
                break;
                
            case 327: // msg 
            	if(myT2CmdRsp.isMsgdataMbrElementBeingParsed())
            	{
                myT2CmdRsp.setMsgdataMbrMsgElementBeingParsed(true);
            	}
                break;
                
            case 987: // cmdsyntax 
                myT2CmdRsp.setCmdsyntaxElementBeingParsed(true);
                break;
                
            case 624: // cmddtd 
                myT2CmdRsp.setCmddtdElementBeingParsed(true);
                break;
                
            case 761: // cmdtext 
                myT2CmdRsp.setCmdtextElementBeingParsed(true);
                break;
                
            case 952: // cmdsecerr 
                myT2CmdRsp.setCmdsecerrElementBeingParsed(true);
                break;
                
            case 442: // exit 
                myT2CmdRsp.setCmdsecerrExitElementBeingParsed(true);
                break;
                
            case 857: // userdata 
                myT2CmdRsp.setCmdsecerrExitUserdataElementBeingParsed(true);
                break;
                
            case 314: // saf 
                myT2CmdRsp.setCmdsecerrSafElementBeingParsed(true);
                break;
                
            case 625: // racfrc 
                myT2CmdRsp.setCmdsecerrSafRacfrcElementBeingParsed(true);
                break;
                
            case 751: // racfrsn 
                myT2CmdRsp.setCmdsecerrSafRacfrsnElementBeingParsed(true);
                break;
                
            case 308: // cmd
                myT2CmdRsp.setCmdElementBeingParsed(true);
                break;
                
            case 652: // master or userid
                if ( qName.trim().toLowerCase().equals("master") )
                {
                    myT2CmdRsp.setCmdMasterElementBeingParsed(true);
                }
                else if ( qName.trim().toLowerCase().equals("userid") )
                {
                    myT2CmdRsp.setCmdUserIdElementBeingParsed(true);
                }
                break;
                
            case 431: // verb
                myT2CmdRsp.setCmdVerbElementBeingParsed(true);
                break;
                
            case 326: // kwd
                myT2CmdRsp.setCmdKwdElementBeingParsed(true);
                break;
                
            case 560: // input
                myT2CmdRsp.setCmdInputElementBeingParsed(true);
                break;
                
            case 967: // cmdrsphdr
                myT2CmdRsp.setCmdrsphdrElementBeingParsed(true);
                Cmdrsphdr newCmdrsphdr = myT2CmdRsp.getCmdrsphdr();
                if(newCmdrsphdr == null)
                    newCmdrsphdr = new CmdrsphdrImpl("");
                myT2CmdRsp.setCmdrsphdr(newCmdrsphdr);
                break;
                
            case 318: // hdr
                // parse Hdr attributes into name-value pairs
                //<hdr slbl="TRAN" llbl="Trancode" scope="LCL" sort="a" key="1" scroll="no" len="8" dtype="CHAR" align="left" />
                
                Hdr lastHdrElement = null; 
                ArrayList<Hdr> hdrArray = (ArrayList<Hdr>)myT2CmdRsp.getImsout().getCmdrsphdr().getHdrArray();
                int hdrArraySize = hdrArray.size(); 
                if (myT2CmdRsp.isCmdrsphdrHdrElementBeingParsed())
                {
                    lastHdrElement = (Hdr)(hdrArray.get(hdrArraySize - 1));
                }
                else
                {
                    lastHdrElement = new HdrImpl("");
                }
/*                
                String lastHdrElementText = ((Hdr)hdrArray.get(hdrArray.size() - 1)).getElementText();
                String[] pairs = lastHdrElementText.split( lastHdrElementText );  // each entry is key="value"
                HashMap<String, String> attrMap = new HashMap<String, String>();
                for ( String pair : pairs )
                {
                    String[] tokens = pair.split("="); 
                    String key = tokens[0];
                    String value = tokens[1].replaceAll("\"", "");
                    attrMap.put( key, value );
                }
*/                
                ((HdrImpl)lastHdrElement).setUri(uri);
                ((HdrImpl)lastHdrElement).setAttributes(attributes);
                ((HdrImpl)lastHdrElement).setSlbl(attributes.getValue(uri, "slbl"));
                ((HdrImpl)lastHdrElement).setLlbl(attributes.getValue(uri, "llbl"));
                ((HdrImpl)lastHdrElement).setScope(attributes.getValue(uri, "scope"));
                ((HdrImpl)lastHdrElement).setSort(attributes.getValue(uri, "sort"));
                ((HdrImpl)lastHdrElement).setKey(attributes.getValue(uri, "key")); 
                ((HdrImpl)lastHdrElement).setScroll(attributes.getValue(uri, "scroll"));
                ((HdrImpl)lastHdrElement).setLen(attributes.getValue(uri, "len"));
                ((HdrImpl)lastHdrElement).setDtype(attributes.getValue(uri, "dtype"));
                ((HdrImpl)lastHdrElement).setAlign(attributes.getValue(uri, "align"));
                ((HdrImpl)lastHdrElement).setSkipb(attributes.getValue(uri, "skipb"));
                
                hdrArray.add(lastHdrElement);
                
                ((CmdrsphdrImpl)myT2CmdRsp.getImsout().getCmdrsphdr()).setHdrArray((ArrayList<Hdr>) hdrArray.clone());
                
                myT2CmdRsp.setCmdrsphdrHdrElementBeingParsed(true);
                break;
                
            case 1059: // cmdrspdata
                myT2CmdRsp.setCmdrspdataElementBeingParsed(true);
                CmdrspdataImpl newCmdrspdata = (CmdrspdataImpl)myT2CmdRsp.getCmdrspdata();
                if(newCmdrspdata == null)
                    newCmdrspdata = new CmdrspdataImpl("");
                newCmdrspdata.setElementText(new String(""));
                myT2CmdRsp.setCmdrspdata(newCmdrspdata);
                break;
                
            case 341: // rsp
                myT2CmdRsp.setCmdrspdataRspElementBeingParsed(true);
                break;
                
            case 737: // msgdata
            	
            	Msgdata newMsgdata = myT2CmdRsp.getImsout().getMsgdata();
                if(newMsgdata == null)
                {
                	newMsgdata = new MsgdataImpl();
                    ((ImsoutImpl)(myT2CmdRsp.getImsout())).setMsgdata(newMsgdata);
                }
                myT2CmdRsp.setMsgdataElementBeingParsed(true);
                break;
        }
    }
    
    public void endElement(String uri, String localName, String qName)
        throws SAXException 
    {
        argHash = MyDefaultHandler.getHashValueFromString(qName.trim().toLowerCase());
        switch (argHash)
        {
            case 673: // imsout
                myT2CmdRsp.setImsOutElementBeingParsed(false);
                myT2CmdRsp.updateType2CmdResponseProperties(this.getMyT2CmdRsp().getImsout());
                break;
                
            case 323: // ctl
                myT2CmdRsp.setCtlElementBeingParsed(false);
                break;
                
            case 637: // omname or cmderr
                if ( qName.trim().toLowerCase().equals("omname") )
                {
                    myT2CmdRsp.setCtlOmnameElementBeingParsed(false);
                }
                else if ( qName.trim().toLowerCase().equals("cmderr") )
                {
                    myT2CmdRsp.setCmderrElementBeingParsed(false);
                }
                break;
                
            case 563: // omvsn
                myT2CmdRsp.setCtlOmvsnElementBeingParsed(false);
                break;
                
            case 680: // xmlvsn
                myT2CmdRsp.setCtlXmlvsnElementBeingParsed(false);
                break;
                
            case 759: // statime
                myT2CmdRsp.setCtlStatimeElementBeingParsed(false);
                break;
                
            case 773: // stotime
                myT2CmdRsp.setCtlStotimeElementBeingParsed(false);
                break;
                
            case 657: // staseq
                myT2CmdRsp.setCtlStaseqElementBeingParsed(false);
                break;
                
            case 671: // stoseq
                myT2CmdRsp.setCtlStoseqElementBeingParsed(false);
                break;
                
            case 840: // rqsttkn1
                myT2CmdRsp.setCtlRqsttkn1ElementBeingParsed(false);
                break;
                
            case 841: // rqsttkn2
                myT2CmdRsp.setCtlRqsttkn2ElementBeingParsed(false);
                break;
                
            case 213: // rc ***** rc used as a sub-element of multiple elements (ctl, cmderr, cmdsecerrExit, cmdsecerrSaf) 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    myT2CmdRsp.setCtlRcElementBeingParsed(false);
                }
                /*else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRcElementBeingParsed(false);
                }*/
                else if(myT2CmdRsp.isCmdsecerrExitElementBeingParsed())
                {
                    myT2CmdRsp.setCmdsecerrExitRcElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmdsecerrSafElementBeingParsed())
                {
                    myT2CmdRsp.setCmdsecerrSafRcElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRcElementBeingParsed(false);
                }
                break;
                
            case 339: // rsn ***** rsn used as a sub-element of ctl and cmderr mbr's only 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    myT2CmdRsp.setCtlRsnElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrRsnElementBeingParsed(false);
                }
                break;
                
            case 666: // rsnmsg
//              myT2CmdRsp.setXxxRsnmsgElementBeingParsed(false);  // is this tag even used???
            	//--------------------------------- 
            	if(myT2CmdRsp.isCtlElementBeingParsed())
                 {
                     myT2CmdRsp.setCtlRsnmsgElementBeingParsed(false);
                 }
            	//----------------------------------------------------
                break;
                
            case 691: // rsntxt
//              myT2CmdRsp.setXxxRsntxtElementBeingParsed(false);  // is this tag even used???
            	//----------------------------------
            	 if(myT2CmdRsp.isCtlElementBeingParsed())
                 {
                     myT2CmdRsp.setCtlRsntxtElementBeingParsed(false);
                 }
                 else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                 {
                     myT2CmdRsp.setCmderrMbrRsntxtBeingParsed(false);
                 }
            	 //--------------------------------------
                break;
                
            case 337: // uom
                myT2CmdRsp.setCtlUomElementBeingParsed(false);
                break;
                
            case 1062: // cmdclients
                myT2CmdRsp.setCmdclientsElementBeingParsed(false);
                break;
                
            case 321: // mbr ***** mbr used as a sub-element of multiple elements (cmdclients, cmderr and msgdata)
                if(myT2CmdRsp.isCmdclientsElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isMsgdataElementBeingParsed())
                {
                    myT2CmdRsp.setMsgdataMbrElementBeingParsed(false);
                }
                this.addNewMbrElement = true;
                break;
                
            case 349: // typ  ***** typ used as a sub-element of multiple elements (cmdclientsMbr and cmderrMbr) 
                if(myT2CmdRsp.isCmdclientsMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrTypElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrTypElementBeingParsed(false);
                }
                break;
                
            case 464: // styp  ***** styp used as a sub-element of multiple elements (cmdclientsMbr and cmderrMbr) 
                if(myT2CmdRsp.isCmdclientsMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmdclientsMbrStypElementBeingParsed(false);
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    myT2CmdRsp.setCmderrMbrStypElementBeingParsed(false);
                }
                break;
                
            case 343: // vsn
                myT2CmdRsp.setCmdclientsMbrVsnElementBeingParsed(false);
                break;
                
            case 732: // jobname
                myT2CmdRsp.setCmdclientsMbrJobnameElementBeingParsed(false);
                break;
                
            case 327: // msg 
            	if(myT2CmdRsp.isMsgdataMbrElementBeingParsed())
                myT2CmdRsp.setMsgdataMbrMsgElementBeingParsed(false);
                this.addNewMsgElement = true;
                break;
                
            case 987: // cmdsyntax 
                myT2CmdRsp.setCmdsyntaxElementBeingParsed(false);
                break;
                
            case 624: // cmddtd 
                myT2CmdRsp.setCmddtdElementBeingParsed(false);
                break;
                
            case 761: // cmdtext 
                myT2CmdRsp.setCmdtextElementBeingParsed(false);
                break;
/*                
            case 637: // cmderr (same hash as (ctl) omname element) 
                myT2CmdRsp.setCmderrElementBeingParsed(false);
                break;
*/                
            case 952: // cmdsecerr 
                myT2CmdRsp.setCmdsecerrElementBeingParsed(false);
                break;
                
            case 442: // exit 
                myT2CmdRsp.setCmdsecerrExitElementBeingParsed(false);
                break;
                
            case 857: // userdata 
                myT2CmdRsp.setCmdsecerrExitUserdataElementBeingParsed(false);
                break;
                
            case 314: // saf 
                myT2CmdRsp.setCmdsecerrSafElementBeingParsed(false);
                break;
                
            case 625: // racfrc 
                myT2CmdRsp.setCmdsecerrSafRacfrcElementBeingParsed(false);
                break;
                
            case 751: // racfrsn 
                myT2CmdRsp.setCmdsecerrSafRacfrcElementBeingParsed(false);
                break;
                
            case 308: // cmd
                myT2CmdRsp.setCmdElementBeingParsed(false);
                break;
                
            case 652: // master or userid
                if ( qName.trim().toLowerCase().equals("master") )
                {
                    myT2CmdRsp.setCmdMasterElementBeingParsed(false);
                }
                else if ( qName.trim().toLowerCase().equals("userid") )
                {
                    myT2CmdRsp.setCmdUserIdElementBeingParsed(false);
                }
                break;
                
            case 431: // verb
                myT2CmdRsp.setCmdVerbElementBeingParsed(false);
//                myT2CmdRsp.setMaster("");
                break;
                
            case 326: // kwd
                myT2CmdRsp.setCmdKwdElementBeingParsed(false);
                break;
                
            case 560: // input
                myT2CmdRsp.setCmdInputElementBeingParsed(false);
                break;
                
            case 967: // cmdrsphdr
                myT2CmdRsp.setCmdrsphdrElementBeingParsed(false);
                break;
                
            case 318: // hdr
                    myT2CmdRsp.setCmdrsphdrHdrElementBeingParsed(false);
                    this.addNewHdrElement = true;
                break;
                
            case 1059: // cmdrspdata
                myT2CmdRsp.setCmdrspdataElementBeingParsed(false);
                break;
                
            case 341: // rsp
/*/////         // for debug only         
              //  System.out.println("Last response element() (a <rsp> element):");
                String[] ResponseElements = myT2CmdRsp.getRspStringArray();
               // System.out.println(ResponseProcessor.formatBufferForTracing(ResponseElements[ResponseElements.length - 1].getBytes(), ApiProperties.DEFAULT_CODEPAGE_ASCII_US));
/////*/         // for debug only         
//                myT2CmdRsp.addAnElementToArrayOfRspElementsProperties(aRspElement);
                myT2CmdRsp.setCmdrspdataRspElementBeingParsed(false);
                myT2CmdRsp.setResponseContainsCmdrspdataElement(true);
                addNewRspElement = true;
              //Added by Shali to Fix ipsdb00096308
                myT2CmdRsp.rspStringArray = null;
                break;
                
            case 737: // msgdata
                myT2CmdRsp.setMsgdataElementBeingParsed(false);
                myT2CmdRsp.setResponseContainsMsgdataElement(true);
                break;
        }
        currentQName = (String)qNameStack.pop();
    }
    
    public void characters(char ch[], int start, int length) throws SAXException 
    {
        argHash = MyDefaultHandler.getHashValueFromString(currentQName.trim().toLowerCase());
        switch (argHash)
        {
            case 673: // imsout
                Imsout newImsout = myT2CmdRsp.getImsout();
                if(myT2CmdRsp.getImsout() != null) 
                    ((ImsoutImpl)newImsout).setElementText(myT2CmdRsp.getImsout().getElementText() + new String(ch, start, length));
                else
                    ((ImsoutImpl)newImsout).setElementText(new String(ch, start, length));
                myT2CmdRsp.setImsout(newImsout);
                break;
                
            case 323: // ctl
                Ctl myCtl = myT2CmdRsp.getImsout().getCtl();

                if(myCtl != null) 
                    ((CtlImpl)myCtl).setCtlElementText(myT2CmdRsp.getImsout().getCtl().getCtlElementText() + new String(ch, start, length));
                else
                {
                    myCtl = new CtlImpl();
                    ((CtlImpl)myCtl).setCtlElementText("");
                }
                myT2CmdRsp.setCtl(myCtl);
                
                break;
                
            case 637: // omname or cmderr
                if ( currentQName.trim().toLowerCase().equals("omname") )
                {
                    if((myT2CmdRsp.getImsout().getCtl().getOmname() != null) && (myT2CmdRsp.getImsout().getCtl().getOmname() != "null"))
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setOmname(myT2CmdRsp.getImsout().getCtl().getOmname() + new String(ch, start, length));
                    else
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setOmname(new String(ch, start, length));
                }
                else if ( currentQName.trim().toLowerCase().equals("cmderr") )
                {
                    CmderrImpl newCmderr = (CmderrImpl)myT2CmdRsp.getCmderr();
                    if(myT2CmdRsp.getImsout().getCmderr() != null) 
                        newCmderr.setElementText(myT2CmdRsp.getImsout().getCmderr().getElementText() + new String(ch, start, length));
                    else
                        newCmderr.setElementText(new String(ch, start, length));
                    myT2CmdRsp.setCmderr(newCmderr);
                }
                break;
                
            case 563: // omvsn
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getOmvsn() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getOmvsn() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setOmvsn(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getOmvsn() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setOmvsn(new String(ch, start, length));
                break;
                
            case 680: // xmlvsn
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getXmlvsn() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getXmlvsn() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setXmlvsn(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getXmlvsn() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setXmlvsn(new String(ch, start, length));
                break;
                
            case 759: // statime
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStatime() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStatime() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStatime(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStatime() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStatime(new String(ch, start, length));
                break;
                
            case 773: // stotime
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStotime() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStotime() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStotime(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStotime() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStotime(new String(ch, start, length));
                break;
                
            case 657: // staseq
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStaseq() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStaseq() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStaseq(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStaseq() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStaseq(new String(ch, start, length));
                break;
                
            case 671: // stoseq
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStoseq() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStoseq() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStoseq(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getStoseq() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setStoseq(new String(ch, start, length));
                break;
                
            case 840: // rqsttkn1
//                myT2CmdRsp.setRequestToken1((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRequestToken1() + new String(ch, start, length)).getBytes()); //???get it directly from data byte array or some bytes may be corrupted or lost
                break;
                
            case 841: // rqsttkn2
//                myT2CmdRsp.setRequestToken1((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRequestToken2() + new String(ch, start, length)).getBytes()); //???get it directly from data byte array or some bytes may be corrupted or lost
              break;
              
            case 213: // rc ***** rc used as a sub-element of multiple elements (ctl, cmdclientsMbr, CmdsecerrExit and CmdsecerrSaf) 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRc() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRc() != "null"))
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRc(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRc() + new String(ch, start, length));
                    else
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRc(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmdclientsMbrElementBeingParsed())
                {
                    ArrayList<Mbr> myMbrArrayList = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                    if((myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() != null) && (myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() != "null"))
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRc(myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRc(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmdsecerrExitElementBeingParsed())
                {
                    if((myT2CmdRsp.getImsout().getCmdsecerr().getExit().getRc() != null) && (myT2CmdRsp.getImsout().getCmdsecerr().getExit().getRc() != "null"))
                        ((ExitImpl)myT2CmdRsp.getImsout().getCmdsecerr().getExit()).setRc(myT2CmdRsp.getImsout().getCmdsecerr().getExit().getRc() + new String(ch, start, length));
                    else
                        ((ExitImpl)myT2CmdRsp.getImsout().getCmdsecerr().getExit()).setRc(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmdsecerrSafElementBeingParsed())
                {
                    if((myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRc() != null) && (myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRc() != "null"))
                        ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRc(myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRc() + new String(ch, start, length));
                    else
                        ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRc(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    ArrayList<Mbr> myMbrArrayList = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    if((myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() != null) && (myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() != "null"))
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRc(myMbrArrayList.get(myMbrArrayList.size() - 1).getRc() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRc(new String(ch, start, length));
                }
                break;
                
            case 339: // rsn ***** rsn used as a sub-element of multiple elements (ctl and cmderr mbr) 
                if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsn() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsn() != "null"))
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsn(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsn() + new String(ch, start, length));
                    else
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsn(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    ArrayList<Mbr> myMbrArrayList = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    if((myMbrArrayList.get(myMbrArrayList.size() - 1).getRsn() != null) && (myMbrArrayList.get(myMbrArrayList.size() - 1).getRsn() != "null"))
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRsn(myMbrArrayList.get(myMbrArrayList.size() - 1).getRsn() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRsn(new String(ch, start, length));
                }
                break;
        
            case 666: // rsnmsg  // is this tag even used???
//                myT2CmdRsp.getImsout().getxxx().getyyy().setRsnmsg(myT2CmdRsp.getImsout().getxxx().getyyy().getRsnmsg() + new String(ch, start, length));
              //-------------------------------------------------------
            	if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsnmsg() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsnmsg() != "null"))
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsnmsg(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsnmsg() + new String(ch, start, length));
                    else
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsnmsg(new String(ch, start, length));
                }
            	//-----------------------------------------------------
            	break;
                
            case 691: // rsntxt  // is this tag even used???
//                myT2CmdRsp.getxxx().getyyy().setRsntxt(myT2CmdRsp.getImsout().getxxx().getyyy().getRsntxt() + new String(ch, start, length));
            	 //---------------------------------------------------------------------
            	if(myT2CmdRsp.isCtlElementBeingParsed())
                {
                    if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsntxt() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsntxt() != "null"))
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsntxt(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getRsntxt() + new String(ch, start, length));
                    else
                        ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setRsntxt(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmderrMbrElementBeingParsed())
                {
                    ArrayList<Mbr> myMbrArrayList = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    if((myMbrArrayList.get(myMbrArrayList.size() - 1).getRsntxt() != null) && (myMbrArrayList.get(myMbrArrayList.size() - 1).getRsntxt() != "null"))
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRsntxt(myMbrArrayList.get(myMbrArrayList.size() - 1).getRsntxt() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myMbrArrayList.get(myMbrArrayList.size() - 1))).setRsntxt(new String(ch, start, length));
                }
            	//--------------------------------------------
            	
            	break;
                
            case 337: // uom
                if((((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getUom() != null) && (((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getUom() != "null"))
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setUom(((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).getUom() + new String(ch, start, length));
                else
                    ((CtlImpl)(myT2CmdRsp.getImsout().getCtl())).setUom(new String(ch, start, length));
                break;
                
            case 1062: // cmdclients
                CmdclientsImpl newCmdclients = (CmdclientsImpl)myT2CmdRsp.getCmdclients();
                if(myT2CmdRsp.getImsout().getCmdclients() != null) 
                    newCmdclients.setCmdclientsElementText(myT2CmdRsp.getImsout().getCmdclients().getCmdclientsElementText() + new String(ch, start, length));
                else
                    newCmdclients.setCmdclientsElementText(new String(ch, start, length));
                myT2CmdRsp.setCmdclients(newCmdclients);
                break;
                
            case 321: // mbr ***** mbr saved as last element in Vector and also used as a sub-element of multiple elements (cmdclients, cmderr and msgdata)
                if(myT2CmdRsp.isCmdclientsElementBeingParsed())
                {
                    ArrayList<Mbr> currentCmdclientsMbr = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                    int currentCmdclientsMbrLength = currentCmdclientsMbr.size();
                    
                    if(addNewMbrElement)
                    {
                        ArrayList<Mbr> newCmdclientsMbr;
                        newCmdclientsMbr = new ArrayList<Mbr>(currentCmdclientsMbrLength + 1);
                        System.arraycopy(currentCmdclientsMbr, 0, newCmdclientsMbr, 0, currentCmdclientsMbrLength);
                        newCmdclientsMbr.add(new MbrImpl(new String(ch, start, length)));
                        ((CmdclientsImpl)(myT2CmdRsp.getImsout().getCmdclients())).setMbr(newCmdclientsMbr);
                    }
                    else // append to last Mbr of cmdclientsMbr Vector
                    {
                        String currentCmdclientsMbrElementText = currentCmdclientsMbr.get(currentCmdclientsMbr.size() - 1).getElementText();
                        ((MbrImpl)(currentCmdclientsMbr.get(currentCmdclientsMbrLength - 1))).setElementText(currentCmdclientsMbrElementText + new String(ch, start, length));
                    }
                    
                    addNewMbrElement = false;
                }
                else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                    ArrayList<Mbr> currentCmderrMbr = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    int currentCmderrMbrLength = currentCmderrMbr.size();
                    
                    if(addNewMbrElement)
                    {
                        ArrayList<Mbr> newCmderrMbr;
                        newCmderrMbr = new ArrayList<Mbr>(currentCmderrMbr);
                       // newCmderrMbr = new ArrayList<Mbr>(currentCmderrMbrLength + 1);
                       // System.arraycopy(currentCmderrMbr, 0, newCmderrMbr, 0, currentCmderrMbrLength);
                        newCmderrMbr.add(new MbrImpl(new String(ch, start, length)));
                        ((CmdclientsImpl)(myT2CmdRsp.getImsout().getCmdclients())).setMbr(newCmderrMbr);
                    }
                    else // append to last Mbr of cmderrMbr Vector
                    {
                        String currentCmderrMbrElementText = currentCmderrMbr.get(currentCmderrMbr.size() - 1).getElementText();
                        ((MbrImpl)(currentCmderrMbr.get(currentCmderrMbrLength - 1))).setElementText(currentCmderrMbrElementText + new String(ch, start, length));
                    }
                    
                    addNewMbrElement = false;
                }
                else if(myT2CmdRsp.isMsgdataElementBeingParsed())
                {
                    ArrayList<Mbr> currentMsgdataMbr = myT2CmdRsp.getImsout().getMsgdata().getMbr();
                    int currentMsgdataMbrLength = currentMsgdataMbr.size();
                    
                    if(addNewMbrElement)
                    {
                        ArrayList<Mbr> newMsgdataMbr;
                        newMsgdataMbr = new ArrayList<Mbr>(currentMsgdataMbr);
                        //newMsgdataMbr = new ArrayList<Mbr>(currentMsgdataMbrLength + 1);
                        //System.arraycopy(currentMsgdataMbr, 0, newMsgdataMbr, 0, currentMsgdataMbrLength);
                        newMsgdataMbr.add(new MbrImpl(new String(ch, start, length)));
                        ((CmdclientsImpl)(myT2CmdRsp.getImsout().getCmdclients())).setMbr(newMsgdataMbr);
                    }
                    else // append to last Mbr of msgdataMbr Vector
                    {
                        String currentMsgdataMbrElementText = currentMsgdataMbr.get(currentMsgdataMbrLength - 1).getElementText();
                        ((MbrImpl)(currentMsgdataMbr.get(currentMsgdataMbrLength - 1))).setElementText(currentMsgdataMbrElementText + new String(ch, start, length));
                    }
                    
                    addNewMbrElement = false;
                }
                break;
                
            case 349: // typ  ***** typ used as a sub-element of multiple elements (cmdclients and cmderr)
                if(myT2CmdRsp.isCmdclientsElementBeingParsed())
                {
                	 ArrayList<Mbr> myCmdclientsMbrArrayList = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                    if((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1).getTyp() != null) && (myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1).getTyp() != "null"))
                        ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setTyp((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1)).getTyp() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setTyp(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                	ArrayList<Mbr> myCmderrMbrArrayList = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    if((myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1).getTyp() != null) && (myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1).getTyp() != "null"))
                        ((MbrImpl)(myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1))).setTyp((myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1)).getTyp() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1))).setTyp(new String(ch, start, length));
                }
                break;
                
            case 464: // styp  ***** styp used as a sub-element of multiple elements (cmdclients and cmderr)
                if(myT2CmdRsp.isCmdclientsElementBeingParsed())
                {
                    ArrayList<Mbr> myCmdclientsMbrArrayList = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                    if((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1).getStyp() != null) && ((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1)).getStyp() != "null"))
                        ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setStyp((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1)).getStyp() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setStyp(new String(ch, start, length));
                }
                else if(myT2CmdRsp.isCmderrElementBeingParsed())
                {
                    ArrayList<Mbr> myCmderrMbrArrayList = myT2CmdRsp.getImsout().getCmderr().getMbr();
                    if((myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1).getStyp() != null) && (myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1).getStyp() != "null"))
                        ((MbrImpl)(myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1))).setStyp(myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1).getStyp() + new String(ch, start, length));
                    else
                        ((MbrImpl)(myCmderrMbrArrayList.get(myCmderrMbrArrayList.size() - 1))).setStyp(new String(ch, start, length));
                }
                break;
                
            case 343: // vsn
                ArrayList<Mbr> myCmdclientsMbrArrayList = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                if((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1).getVsn() != null) && (myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1).getVsn() != "null"))
                    ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setVsn((myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1)).getVsn() + new String(ch, start, length));
                else
                    ((MbrImpl)(myCmdclientsMbrArrayList.get(myCmdclientsMbrArrayList.size() - 1))).setVsn(new String(ch, start, length));
                break;
                
            case 732: // jobname
                ArrayList<Mbr> myCmdclientsMbrArrayList1 = myT2CmdRsp.getImsout().getCmdclients().getMbr();
                if((myCmdclientsMbrArrayList1.get(myCmdclientsMbrArrayList1.size() - 1).getJobname() != null) && (myCmdclientsMbrArrayList1.get(myCmdclientsMbrArrayList1.size() - 1).getJobname() != "null"))
                    ((MbrImpl)(myCmdclientsMbrArrayList1.get(myCmdclientsMbrArrayList1.size() - 1))).setJobname((myCmdclientsMbrArrayList1.get(myCmdclientsMbrArrayList1.size() - 1)).getJobname() + new String(ch, start, length));
                else
                    ((MbrImpl)(myCmdclientsMbrArrayList1.get(myCmdclientsMbrArrayList1.size() - 1))).setJobname(new String(ch, start, length));
                break;
                
            case 327: // msg 
            	if(myT2CmdRsp.isMsgdataMbrMsgElementBeingParsed())
            	{
	            	ArrayList<Mbr> myMsgdataMbrArrayList = myT2CmdRsp.getImsout().getMsgdata().getMbr();
	                if(myMsgdataMbrArrayList == null)
	                {
	                    ArrayList<Mbr> newMsgdataMbr = new ArrayList<Mbr>(1);
	                    ((MsgdataImpl)(myT2CmdRsp.getImsout().getMsgdata())).setMbr(newMsgdataMbr);
	                }
	                String[] newMsgdataMbrMsg;
	                
	                int msgdataMbrMsgLength = 0;
	                if (myMsgdataMbrArrayList.get(myMsgdataMbrArrayList.size() - 1).getMsg() != null)
	                    msgdataMbrMsgLength = myMsgdataMbrArrayList.get(myMsgdataMbrArrayList.size() - 1).getMsg().length;
	                if(addNewMsgElement)
	                {
	                    newMsgdataMbrMsg = new String[msgdataMbrMsgLength + 1];
	                    if(msgdataMbrMsgLength > 0) 
	                    System.arraycopy(myMsgdataMbrArrayList.get(myMsgdataMbrArrayList.size() - 1).getMsg(), 0, newMsgdataMbrMsg, 0, msgdataMbrMsgLength);
	                    newMsgdataMbrMsg[msgdataMbrMsgLength] = new String(ch, start, length);
	                }
	                else
	                {
	                    newMsgdataMbrMsg = (myMsgdataMbrArrayList.get(myMsgdataMbrArrayList.size() - 1).getMsg().clone());
	                    newMsgdataMbrMsg[msgdataMbrMsgLength-1] += new String(ch, start, length);
	                }
	                ((MbrImpl)(myMsgdataMbrArrayList.get(myMsgdataMbrArrayList.size() - 1))).setMsg(newMsgdataMbrMsg);
	                
            	}
            	addNewMsgElement = false;
                break;
                
            case 987: // cmdsyntax 
                if((myT2CmdRsp.getImsout().getCmdsyntax() != null) && (myT2CmdRsp.getImsout().getCmdsyntax() != "null"))
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdsyntax(myT2CmdRsp.getImsout().getCmdsyntax() + new String(ch, start, length));
                else
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdsyntax(new String(ch, start, length));
                break;
                
            case 624: // cmddtd 
                if((myT2CmdRsp.getImsout().getCmddtd() != null) && (myT2CmdRsp.getImsout().getCmddtd() != "null"))
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmddtd(myT2CmdRsp.getImsout().getCmddtd() + new String(ch, start, length));
                else
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmddtd(new String(ch, start, length));
                break;
                
            case 761: // cmdtext 
                if((myT2CmdRsp.getImsout().getCmdtext() != null) && (myT2CmdRsp.getImsout().getCmdtext() != "null"))
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdtext(myT2CmdRsp.getImsout().getCmdtext() + new String(ch, start, length));
                else
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdtext(new String(ch, start, length));
                break;
/**                
            case 637: // cmderr (see omname which uses same hashcode)  
                myT2CmdRsp.setCmderrElementBeingParsed(false);
                break;
**/                
            case 952: // cmdsecerr 
                Cmdsecerr newCmdsecerr = myT2CmdRsp.getCmdsecerr();
                if(myT2CmdRsp.getImsout().getCmdsecerr() != null) 
                    ((CmdsecerrImpl)newCmdsecerr).setElementText(myT2CmdRsp.getImsout().getCmdsecerr().getElementText() + new String(ch, start, length));
                else
                    ((CmdsecerrImpl)newCmdsecerr).setElementText(new String(ch, start, length));
                myT2CmdRsp.setCmdsecerr(newCmdsecerr);
                break;
                
            case 442: // exit 
                if(myT2CmdRsp.getImsout().getCmdsecerr().getExit() != null)
                    ((CmdsecerrImpl)myT2CmdRsp.getImsout().getCmdsecerr()).setElementText(myT2CmdRsp.getImsout().getCmdsecerr().getExit().getElementText() + new String(ch, start, length));
                else
                    ((CmdsecerrImpl)myT2CmdRsp.getImsout().getCmdsecerr()).setExit(new ExitImpl(new String(ch, start, length)));
                break;
                
            case 857: // userdata 
                if((myT2CmdRsp.getImsout().getCmdsecerr().getExit().getUserdata() != null) && (myT2CmdRsp.getImsout().getCmdsecerr().getExit().getUserdata() != "null"))
                    ((ExitImpl)myT2CmdRsp.getImsout().getCmdsecerr().getExit()).setUserdata(myT2CmdRsp.getImsout().getCmdsecerr().getExit().getUserdata() + new String(ch, start, length));
                else
                    ((ExitImpl)myT2CmdRsp.getImsout().getCmdsecerr().getExit()).setUserdata(new String(ch, start, length));
                break;
                
            case 314: // saf 
                myT2CmdRsp.setCmdsecerrSafElementBeingParsed(false);
                break;
                
            case 625: // racfrc 
                if((myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrc() != null) && (myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrc() != "null"))
                    ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRacfrc(myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrc() + new String(ch, start, length));
                else
                    ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRacfrc(new String(ch, start, length));
                break;
                
            case 751: // racfrsn 
                if((myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrsn() != null) && (myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrsn() != "null"))
                    ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRacfrsn(myT2CmdRsp.getImsout().getCmdsecerr().getSaf().getRacfrsn() + new String(ch, start, length));
                else
                    ((SafImpl)(myT2CmdRsp.getImsout().getCmdsecerr().getSaf())).setRacfrsn(new String(ch, start, length));
                break;
                
            case 308: // cmd 
                if(myT2CmdRsp.getImsout().getCmd() != null) 
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmd((Cmd)(new CmdImpl(myT2CmdRsp.getImsout().getCmd() + new String(ch, start, length))));
                else
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmd((Cmd)(new CmdImpl(new String(ch, start, length))));
                break;
                
            case 652: // master
                if ( currentQName.trim().equalsIgnoreCase("master") )
                {
                    if((myT2CmdRsp.getImsout().getCmd().getMaster() != null) && (myT2CmdRsp.getImsout().getCmd().getMaster() != "null"))
                        ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setMaster(myT2CmdRsp.getImsout().getCmd().getMaster() + new String(ch, start, length));
                    else
                        ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setMaster(new String(ch, start, length));
                }
                else if ( currentQName.trim().equalsIgnoreCase("userid") )
                {
                    if((myT2CmdRsp.getImsout().getCmd().getUserid() != null) && (myT2CmdRsp.getImsout().getCmd().getUserid() != "null"))
                        ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setUserid(myT2CmdRsp.getImsout().getCmd().getUserid() + new String(ch, start, length));
                    else
                        ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setUserid(new String(ch, start, length));
                }
                break;
                
//            case 652: // userid (see master above)
//                myT2CmdRsp.getImsout().getCmd().setUserId(myT2CmdRsp.getImsout().getCmd().getUserId() + new String(ch, start, length));
//                break;
                
            case 431: // verb
                if((myT2CmdRsp.getImsout().getCmd().getVerb() != null) && (myT2CmdRsp.getImsout().getCmd().getVerb() != "null"))
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setVerb(myT2CmdRsp.getImsout().getCmd().getVerb() + new String(ch, start, length));
                else
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setVerb(new String(ch, start, length));
                break;
                
            case 326: // kwd
                if((myT2CmdRsp.getImsout().getCmd().getKwd() != null) && (myT2CmdRsp.getImsout().getCmd().getKwd() != "null"))
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setKwd(myT2CmdRsp.getImsout().getCmd().getKwd() + new String(ch, start, length));
                else
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setKwd(new String(ch, start, length));
                break;
                
            case 560: // input
                if((myT2CmdRsp.getImsout().getCmd().getInput() != null) && (myT2CmdRsp.getImsout().getCmd().getInput() != "null"))
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setInput(myT2CmdRsp.getImsout().getCmd().getInput() + new String(ch, start, length));
                else
                    ((CmdImpl)(myT2CmdRsp.getImsout().getCmd())).setInput(new String(ch, start, length));
                break;
                
            case 967: // cmdrsphdr
                if((myT2CmdRsp.getImsout().getCmdrsphdr() != null)) // && (myT2CmdRsp.getImsout().getCmdrsphdr().getElementText() != "null"))
                    ((CmdrsphdrImpl)myT2CmdRsp.getImsout().getCmdrsphdr()).setElementText(myT2CmdRsp.getImsout().getCmdrsphdr() + new String(ch, start, length));
                else
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdrsphdr(new CmdrsphdrImpl(new String(ch, start, length)));
                break;
                
            case 318: // hdr
                Hdr lastHdrElement = null;
                String lastHdrElementText = "";
                ArrayList<Hdr> hdrArray = (ArrayList<Hdr>)myT2CmdRsp.getImsout().getCmdrsphdr().getHdrArray().clone();
                if(hdrArray != null)
                {
                    lastHdrElement = (Hdr)(hdrArray.get(hdrArray.size() - 1));
                    lastHdrElementText = lastHdrElement.getElementText();
                }
                
                if((lastHdrElement != null) && (lastHdrElementText != ""))
                    ((CmdrsphdrImpl)myT2CmdRsp.getImsout().getCmdrsphdr()).setHdrArrayElement(new HdrImpl(myT2CmdRsp.getImsout().getCmdrsphdr().getHdrArray() + new String(ch, start, length)), hdrArray.size() - 1);
                else
                    ((CmdrsphdrImpl)myT2CmdRsp.getImsout().getCmdrsphdr()).setHdrArrayElement(new HdrImpl(new String(ch, start, length)), hdrArray.size() - 1);
                break;
                
            case 1059: // cmdrspdata
                if((myT2CmdRsp.getImsout().getCmdrspdata() != null) && (myT2CmdRsp.getImsout().getCmdrspdata().getElementText() != "null"))
                    ((ImsoutImpl)myT2CmdRsp.getImsout()).setCmdrspdata(new CmdrspdataImpl(myT2CmdRsp.getImsout().getCmdrspdata().getElementText() + new String(ch, start, length)));
                else
                    ((CmdrspdataImpl)(myT2CmdRsp.getImsout().getCmdrspdata())).setElementText(new String(ch, start, length));
                break;
                
            case 341: // rsp
                if (addNewRspElement)
                    myT2CmdRsp.addResponseElement(new String(ch, start, length), addNewRspElement);
                else 
                {
                    String[] responseElements = myT2CmdRsp.getRspStringArray();
                    myT2CmdRsp.addResponseElement(responseElements[responseElements.length - 1] + new String(ch, start, length), addNewRspElement);
                }
                addNewRspElement = false;
                break;
                
            case 737: // msgdata
               /* if((myT2CmdRsp.getImsout().getMsgdata() != null) && (myT2CmdRsp.getImsout().getMsgdata().getElementText() != "null"))
                    ((MsgdataImpl)(myT2CmdRsp.getImsout().getMsgdata())).setElementText(myT2CmdRsp.getImsout().getMsgdata() + new String(ch, start, length));
                else
                {
                   // ((MsgdataImpl)(myT2CmdRsp.getImsout().getMsgdata())).setElementText(new String(ch, start, length));

                	 ((ImsoutImpl)(myT2CmdRsp.getImsout())).setMsgdata(new MsgdataImpl());
                }*/
                
                
                MsgdataImpl newMsgdata = (MsgdataImpl)myT2CmdRsp.getMsgdata();
                if(myT2CmdRsp.getImsout().getMsgdata() != null) 
                    newMsgdata.setElementText(myT2CmdRsp.getImsout().getMsgdata().getElementText() + new String(ch, start, length));
                else
                    newMsgdata.setElementText(new String(ch, start, length));
                myT2CmdRsp.setMsgdata(newMsgdata);
                
                break;
                
                
        }
    }
    
    public static short getHashValueFromString(String argument)
    {
        short hash = 0;
        char[] argCharArray = argument.trim().toLowerCase().toCharArray();
        
        for (int i = 0; i < argument.length(); i++)
        {
            hash += argCharArray[i];
        }
        return hash;
    }
    
    
    /*public static void main(String args[]) 
    {
        for (int i = 0; i < args.length; i++)
        {
            System.out.println(args[i].toLowerCase() + "=" + getHashValueFromString(args[i]));
        }
    }*/

    /**
     * @return the myT2CmdRsp
     */
    public Type2CmdResponse getMyT2CmdRsp()
    {
        return this.myT2CmdRsp;
    }

    /**
     * @param myT2CmdRsp the myT2CmdRsp to set
     */
    public void setMyT2CmdRsp(Type2CmdResponse myT2CmdRsp)
    {
        this.myT2CmdRsp = myT2CmdRsp;
    }
}