/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class LookupFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$lookup");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$lookup");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$lookup");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$lookup");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        NullNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1 && argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argObject == null) return result;
        if (!argObject.isObject()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        if (argCount != 2) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        JsonNode keyObj = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (keyObj == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!keyObj.isTextual()) {
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        String key = keyObj.asText();
        ObjectNode obj = (ObjectNode)argObject;
        return obj.get(key);
    }

    @Override
    public String getSignature() {
        return "<o-s:x>";
    }
}

