/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.commons.lang3.StringUtils;

public class PadFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$pad");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$pad");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$pad");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$pad");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$pad");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : (argCount == 1 ? ERR_ARG1BADTYPE : ERR_ARG4BADTYPE));
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        JsonNode argWidth = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argString == null) return result;
        if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        String str = argString.textValue();
        int width = 0;
        if (argWidth == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!argWidth.isNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        width = argWidth.asInt();
        String padStr = " ";
        if (argCount == 3) {
            JsonNode argChar = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2);
            if (argChar == null) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            if (!argChar.isTextual()) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            padStr = argChar.asText();
        }
        if (width >= 0) return new TextNode(StringUtils.rightPad(str, width, padStr));
        return new TextNode(StringUtils.leftPad(str, -width, padStr));
    }

    @Override
    public String getSignature() {
        return "<s-ns?:s>";
    }
}

