/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DeclaredFunction {
    MappingExpressionParser.VarListContext _varList;
    MappingExpressionParser.ExprListContext _exprList;

    public DeclaredFunction(MappingExpressionParser.VarListContext varList, MappingExpressionParser.ExprListContext exprList) {
        if (varList == null) {
            throw new EvaluateRuntimeException("VarListContext passed is null.");
        }
        if (exprList == null) {
            throw new EvaluateRuntimeException("ExprListContext passed is null.");
        }
        this._varList = varList;
        this._exprList = exprList;
    }

    public MappingExpressionParser.ExprListContext getExpressionList() {
        return this._exprList;
    }

    public List<TerminalNode> getVariables() {
        List<TerminalNode> variables = this._varList.getTokens(45);
        if (variables == null) {
            variables = new ArrayList<TerminalNode>();
        }
        return variables;
    }

    public int getVariableCount() {
        return this.getVariables().size();
    }

    public JsonNode invoke(ExpressionsVisitor expressionVisitor, ParserRuleContext ruleValues) {
        JsonNode result = null;
        MappingExpressionParser.ExprValuesContext exprValues = null;
        if (ruleValues instanceof MappingExpressionParser.ExprValuesContext) {
            int exprListCount;
            exprValues = (MappingExpressionParser.ExprValuesContext)ruleValues;
            List<TerminalNode> varListCtx = this._varList.VAR_ID();
            List<MappingExpressionParser.ExprContext> exprValuesCtx = exprValues.exprList().expr();
            int varListCount = varListCtx.size();
            if (varListCount != (exprListCount = exprValuesCtx.size())) {
                throw new EvaluateRuntimeException("Expected equal counts for varibles (" + varListCount + ") and values (" + exprListCount + ")");
            }
            for (int i = 0; i < varListCount; ++i) {
                String varID = varListCtx.get(i).getText();
                JsonNode value = (JsonNode)expressionVisitor.visit(exprValuesCtx.get(i));
                expressionVisitor.getVariableMap().put(varID, value);
            }
        }
        result = (JsonNode)expressionVisitor.visit(this._exprList);
        return result;
    }
}

