/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class ShuffleFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$shuffle");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$shuffle");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$shuffle");
    public static String ERR_ARG1_MUST_BE_ARRAY = String.format("Argument 1 of function \"%s\" must be an an array", "$shuffle");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        JsonNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argArray == null) {
            throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        }
        if (argArray.isArray()) {
            int i;
            ArrayNode array = (ArrayNode)argArray;
            result = JsonNodeFactory.instance.arrayNode(array.size());
            for (i = 0; i < array.size(); ++i) {
                result.add(0);
            }
            for (i = 0; i < array.size(); ++i) {
                int j = new Double(Math.floor(Math.random() * (double)(i + 1))).intValue();
                if (i != j) {
                    result.set(i, result.get(j));
                }
                result.set(j, array.get(i));
            }
            return result;
        } else {
            result.add(argArray);
            return result;
        }
    }

    @Override
    public String getSignature() {
        return "<x-:a>";
    }
}

