/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.generated.MappingExpressionLexer;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;

public class Expressions {
    ParseTree tree = null;
    String expression = null;
    ExpressionsVisitor _eval = new ExpressionsVisitor(JsonNodeFactory.instance.objectNode());

    public static List<String> getRefsInExpression(Pattern refPattern, String expression) {
        Matcher matcher = refPattern.matcher(expression);
        LinkedList<String> matches = new LinkedList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public Expressions(ParseTree aTree, String anExpression) {
        this.tree = aTree;
        this.expression = anExpression;
    }

    public static Expressions parse(String mappingExpression) throws ParseException {
        ANTLRInputStream input = new ANTLRInputStream(mappingExpression);
        MappingExpressionLexer lexer = new MappingExpressionLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        MappingExpressionParser parser = new MappingExpressionParser(tokens);
        MappingExpressionParser.ExprContext tree = null;
        BufferingErrorListener errorListener = new BufferingErrorListener();
        try {
            parser.removeErrorListeners();
            lexer.removeErrorListeners();
            parser.addErrorListener(errorListener);
            lexer.addErrorListener(errorListener);
            tree = parser.expr();
            if (errorListener.heardErrors()) {
                ParseTree error;
                if (tree != null && tree.getChildCount() > 0 && (error = tree.getChild(0)) instanceof ErrorNodeImpl && ((ErrorNodeImpl)error).getSymbol().getType() == 27) {
                    throw new EvaluateRuntimeException("The symbol \"~>\" cannot be used as a unary operator");
                }
                throw new ParseException(errorListener.getErrorsAsString());
            }
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage());
        }
        return new Expressions(tree, mappingExpression);
    }

    public JsonNode evaluate(JsonNode rootContext) throws EvaluateException {
        ExpressionsVisitor eval;
        JsonNode result = null;
        this._eval = eval = new ExpressionsVisitor(rootContext);
        try {
            result = (JsonNode)this._eval.visit(this.tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public ExpressionsVisitor getExpr() {
        return this._eval;
    }

    public void setExpr(ExpressionsVisitor expr) {
        this._eval = expr;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public void setTree(ParseTree parsetree) {
        this.tree = parsetree;
    }

    public String toString() {
        return this.expression;
    }
}

