/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.Sequence;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.rmi.dgc.VMID;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.management.modelmbean.InvalidTargetObjectTypeException;

public class JSONataUtils
implements Serializable {
    private static final long serialVersionUID = 8109772978213632637L;
    public static final DecimalFormat FMT = new DecimalFormat("#0.000");
    public static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 65, 66, 67, 68, 69, 70};
    public static final int DAY_MS = 86400000;
    public static final int HOUR_MS = 3600000;
    public static final int MIN_MS = 60000;
    public static final String HEX_CHARS = "0123456789ABCDEF";
    public static Random SEED_RANDOM = new Random();
    public static SecureRandom SEED_SECURE_RANDOM = null;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static void closeTextFile(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static char[] byteToHexChars(byte bIn) {
        char[] cOut = new char[2];
        int iMasker = bIn & 0xFF;
        int iMaskerHigh = iMasker & 0xF0;
        int iMaskerLow = iMasker & 0xF;
        iMaskerHigh = (iMaskerHigh >>= 4) > 9 ? iMaskerHigh + 65 - 10 : (iMaskerHigh += 48);
        iMaskerLow = iMaskerLow > 9 ? iMaskerLow + 65 - 10 : (iMaskerLow += 48);
        cOut[0] = (char)iMaskerHigh;
        cOut[1] = (char)iMaskerLow;
        return cOut;
    }

    public static synchronized String getUniqueID() {
        byte[] byteID = new byte[20];
        if (SEED_SECURE_RANDOM != null) {
            SEED_SECURE_RANDOM.nextBytes(byteID);
            return JSONataUtils.hexEncode(byteID);
        }
        Date date = new Date();
        StringBuffer sb = new StringBuffer();
        sb.append("X");
        sb.append(Long.toHexString(date.getTime()));
        sb.append(Long.toHexString(SEED_RANDOM.nextLong()));
        return sb.toString();
    }

    public static byte[] hexDecode(String strHex) throws InvalidParameterException {
        if (strHex == null || strHex.length() == 0) {
            throw new InvalidParameterException("Null or empty string passed.  Must pass string containing pairs of hexadecimal digits.");
        }
        int iLength = strHex.length();
        if (iLength % 2 > 0) {
            throw new InvalidParameterException("An odd number of bytes was passed in the input string.  Must be an even number.");
        }
        byte[] inBytes = strHex.toUpperCase().getBytes(UTF8_CHARSET);
        byte[] baRC = new byte[iLength / 2];
        int iHighOffset = -1;
        int iLowOffset = -1;
        for (int i = 0; i < iLength; i += 2) {
            iHighOffset = HEX_CHARS.indexOf(inBytes[i]);
            if (iHighOffset < 0) {
                throw new InvalidParameterException("Input string contains non-hexadecimal digit at index " + i + ".  Must be 0-9 or A-F");
            }
            iLowOffset = HEX_CHARS.indexOf(inBytes[i + 1]);
            if (iLowOffset < 0) {
                throw new InvalidParameterException("Input string contains non-hexadecimal digit at index " + i + ".  Must be 0-9 or A-F");
            }
            baRC[i / 2] = (byte)(iHighOffset * 16 + iLowOffset);
        }
        return baRC;
    }

    public static String hexEncode(byte[] bArray) {
        StringBuffer sb = new StringBuffer();
        if (bArray == null || bArray.length == 0) {
            return sb.toString();
        }
        char[] cHexPair = new char[2];
        int iArrayLength = bArray.length;
        for (int iByteCount = 0; iByteCount < iArrayLength; ++iByteCount) {
            cHexPair = JSONataUtils.byteToHexChars(bArray[iByteCount]);
            sb.append(new String(cHexPair));
        }
        return sb.toString();
    }

    public static BufferedReader openTextFile(String fqFilename) throws Exception {
        BufferedReader input = null;
        File inputFile = new File(fqFilename);
        if (!inputFile.exists()) {
            throw new Exception(inputFile.getCanonicalPath() + " does not exist.");
        }
        if (!inputFile.isFile()) {
            throw new IOException("Input is not a file: " + inputFile.getCanonicalPath() + File.separator + inputFile.getName());
        }
        if (!inputFile.canRead()) {
            throw new IOException("Can not read file " + inputFile.getCanonicalPath() + File.separator + inputFile.getName());
        }
        input = new BufferedReader(new FileReader(inputFile));
        return input;
    }

    public static String prompt(String strPrompt) {
        return JSONataUtils.prompt(strPrompt, true);
    }

    public static String prompt(String strPrompt, boolean bTrim) {
        String strReply = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            if (strPrompt != null && strPrompt.length() != 0) {
                System.out.println(strPrompt);
            }
            strReply = in.readLine();
            if (bTrim && strReply != null) {
                strReply = strReply.trim();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return strReply;
    }

    public static JsonNode saveJSONFile(String jsonFileName, JsonNode jsonData) throws Exception {
        if (jsonData == null) {
            throw new InvalidObjectException("jsonData is null");
        }
        if (jsonFileName == null || jsonFileName.trim().length() == 0) {
            throw new InvalidTargetObjectTypeException("Output filename is null or empty.");
        }
        BufferedWriter br = null;
        try {
            File outputFile = new File(jsonFileName);
            br = new BufferedWriter(new FileWriter(outputFile));
            ObjectMapper mapper = new ObjectMapper();
            br.write(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonData));
        }
        catch (IOException e) {
            throw new IOException("Can not write file \"" + jsonFileName + "\"", e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return jsonData;
    }

    public static List<Path> listSourceFiles(Path dir, String ext) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.{" + ext + "}");){
            for (Path entry : stream) {
                result.add(entry);
            }
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
        result.sort(null);
        return result;
    }

    public static JsonNode loadJSONFile(String jsonFQFileName) throws Exception {
        NullNode retObj = JsonNodeFactory.instance.nullNode();
        BufferedReader br = null;
        try {
            br = JSONataUtils.openTextFile(jsonFQFileName);
            if (br != null) {
                ObjectMapper mapper = new ObjectMapper();
                retObj = (JsonNode)mapper.readValue((Reader)br, Object.class);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Can not parse \"" + jsonFQFileName + "\"", ioe);
        }
        catch (Exception e) {
            throw new IOException("Can not load file \"" + jsonFQFileName + "\"", e);
        }
        finally {
            JSONataUtils.closeTextFile(br);
        }
        return retObj;
    }

    public static String readLine(BufferedReader br) throws IOException {
        HashSet<Integer> terminators = new HashSet<Integer>();
        terminators.add(10);
        return JSONataUtils.readLine(br, terminators);
    }

    public static String readLine(BufferedReader br, HashSet<Integer> terminators) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = br.read();
        while (c != -1) {
            if (terminators.contains(c)) {
                return sb.toString();
            }
            sb.append((char)c);
            c = br.read();
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    static boolean isArrayOfStrings(Object arg) {
        boolean result = false;
        if (arg != null && arg.getClass().isArray()) {
            if (arg instanceof String[]) {
                result = true;
            } else if (arg instanceof Object[]) {
                Object[] testArray = (Object[])arg;
                boolean tester = true;
                for (Object test : testArray) {
                    if (test instanceof String) continue;
                    tester = false;
                    break;
                }
                result = tester;
            }
        }
        return result;
    }

    static boolean isArrayOfNumbers(Object arg) {
        boolean result = false;
        if (arg != null && arg.getClass().isArray()) {
            if (arg instanceof Number[]) {
                result = true;
            } else if (arg instanceof Object[]) {
                Object[] testArray = (Object[])arg;
                boolean tester = true;
                for (Object test : testArray) {
                    if (test instanceof Number) continue;
                    tester = false;
                    break;
                }
                result = tester;
            } else if (arg instanceof int[] || arg instanceof long[] || arg instanceof float[] || arg instanceof double[]) {
                result = true;
            }
        }
        return result;
    }

    public static Sequence createSequence(JsonNode ... arguments) {
        Sequence seq = new Sequence();
        if (arguments != null && arguments.length == 1) {
            seq.push(arguments[0]);
        }
        return seq;
    }

    public static boolean isSequence(Object value) {
        return value instanceof Sequence;
    }

    public static void main(String[] args) throws Exception {
        int[] intArray = new int[]{-1, 0, 1, 2, 3};
        Integer[] integerArray = new Integer[]{-1, 0, 1, 2, 3};
        String[] strArray = new String[]{"a", "b", "c", "x", "y", "z"};
        Object[] objArray = new Object[]{"a", "b", "c", "x", "y", "z"};
        Object[] mixedArray = new Object[]{"a", "b", "c", -1, 0, 1, 2, 3};
        System.out.println("intArray isArrayOfStrings = " + JSONataUtils.isArrayOfStrings(intArray));
        System.out.println("integerArray isArrayOfStrings = " + JSONataUtils.isArrayOfStrings(integerArray));
        System.out.println("strArray isArrayOfStrings = " + JSONataUtils.isArrayOfStrings(strArray));
        System.out.println("objArray isArrayOfStrings = " + JSONataUtils.isArrayOfStrings(objArray));
        System.out.println("mixedArray isArrayOfStrings = " + JSONataUtils.isArrayOfStrings(mixedArray));
        System.out.println("intArray isArrayOfNumbers = " + JSONataUtils.isArrayOfNumbers(intArray));
        System.out.println("integerArray isArrayOfNumbers = " + JSONataUtils.isArrayOfNumbers(integerArray));
        System.out.println("strArray isArrayOfNumbers = " + JSONataUtils.isArrayOfNumbers(strArray));
        System.out.println("objArray isArrayOfNumbers = " + JSONataUtils.isArrayOfNumbers(objArray));
        System.out.println("mixedArray isArrayOfNumbers = " + JSONataUtils.isArrayOfNumbers(mixedArray));
        System.out.println("createSequence()=" + JSONataUtils.createSequence(new JsonNode[0]));
        System.out.println("createSequence(null)=" + JSONataUtils.createSequence(null));
        System.out.println("createSequence(JsonNodeFactory.instance.objectNode())=" + JSONataUtils.createSequence(new JsonNode[]{JsonNodeFactory.instance.objectNode()}));
        System.out.println("createSequence(new JSONObject())=" + JSONataUtils.createSequence(new JsonNode[]{JsonNodeFactory.instance.objectNode()}));
        System.out.println("createSequence(new JSONArray())=" + JSONataUtils.createSequence(new JsonNode[]{JsonNodeFactory.instance.arrayNode()}));
        System.out.println("createSequence(NullNode.instance)=" + JSONataUtils.createSequence(new JsonNode[]{NullNode.instance}));
    }

    static {
        try {
            SEED_SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
            SEED_SECURE_RANDOM.setSeed(new VMID().toString().getBytes());
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("Unable to retrieve algorithm SHA1PRNG for unique id generation.");
        }
    }
}

