/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.ArrayUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import org.antlr.v4.runtime.tree.ParseTree;

public class SortFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$sort");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$sort");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$sort");
    public static String ERR_FCTNOTFOUND = String.format("Can not find a declared function as second argument of function \"%s\".", "$sort");
    public static String ERR_ARG1BADARRAYTYPE = String.format("Argument 1 of function \"%s\" must be an an array", "$sort");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        NullNode arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount == 1) {
            if (!useContext) {
                arg = expressionVisitor.visit((ParseTree)ctx.exprValues().exprList().expr(0));
            }
            if (arg == null) {
                return null;
            }
            if (arg.isArray()) {
                ArrayNode array = (ArrayNode)arg;
                for (int i = 0; i < array.size(); ++i) {
                    result.add(array.get(i));
                }
                this.msort(result, null, expressionVisitor, ctx);
                return result;
            }
            result.add((JsonNode)arg);
            return result;
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        DeclaredFunction fct = null;
        if (!useContext) {
            arg = expressionVisitor.visit((ParseTree)ctx.exprValues().exprList().expr(0));
        }
        if (arg == null) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        MappingExpressionParser.ExprContext fctCtx = ctx.exprValues().exprList().expr(useContext ? 0 : 1);
        if (fctCtx == null) {
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        if (!(fctCtx instanceof MappingExpressionParser.Function_declContext)) {
            if (!(fctCtx instanceof MappingExpressionParser.Var_recallContext)) {
                throw new EvaluateRuntimeException("Expected an function declaration reference but got " + fctCtx.getText() + " that is an " + ((Object)((Object)fctCtx)).getClass().getName());
            }
            String varID = ((MappingExpressionParser.Var_recallContext)fctCtx).VAR_ID().getText();
            fct = expressionVisitor.getFunctionMap().get(varID);
            if (fct == null) {
                throw new EvaluateRuntimeException(String.format("Can not find a declared function for variable \"%s\" of function \"%s\".", varID, "$sort"));
            }
        } else {
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)fctCtx;
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
            try {
                fct = new DeclaredFunction(varList, exprList);
            }
            catch (EvaluateRuntimeException e) {
                throw new EvaluateRuntimeException(ERR_FCTNOTFOUND);
            }
        }
        if (arg.isArray()) {
            ArrayNode array = (ArrayNode)arg;
            for (int i = 0; i < array.size(); ++i) {
                result.add(array.get(i));
            }
            this.msort(result, fct, expressionVisitor, ctx);
            return result;
        } else {
            result.add((JsonNode)arg);
        }
        return result;
    }

    @Override
    public String getSignature() {
        return "<x-f?:n>";
    }

    void msort(ArrayNode array, DeclaredFunction fct, ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx) {
        int n = array.size();
        if (array == null || n < 2) {
            return;
        }
        int middle = (int)Math.floor(n / 2);
        ArrayNode left = ArrayUtils.slice(array, 0, middle);
        ArrayNode right = ArrayUtils.slice(array, middle);
        this.msort(left, fct, exprVisitor, ctx);
        this.msort(right, fct, exprVisitor, ctx);
        this.merge(array, left, right, fct, exprVisitor, ctx);
    }

    void merge(ArrayNode array, ArrayNode left, ArrayNode right, DeclaredFunction fct, ExpressionsVisitor exprVisitor, MappingExpressionParser.Function_callContext ctx) {
        int lSize = left.size();
        int rSize = right.size();
        int i = 0;
        int j = 0;
        int k = 0;
        if (fct == null) {
            while (i < lSize && j < rSize) {
                if (ArrayUtils.compare(left.get(i), right.get(j))) {
                    array.set(k++, right.get(j++));
                    continue;
                }
                array.set(k++, left.get(i++));
            }
            while (i < lSize) {
                array.set(k++, left.get(i++));
            }
            while (j < rSize) {
                array.set(k++, right.get(j++));
            }
        } else {
            while (i < lSize && j < rSize) {
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx.getParent(), ctx.invokingState);
                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, left.get(i), right.get(j));
                JsonNode comp = fct.invoke(exprVisitor, evc);
                if (comp != null && comp.asBoolean()) {
                    array.set(k++, right.get(j++));
                    continue;
                }
                array.set(k++, left.get(i++));
            }
            while (i < lSize) {
                array.set(k++, left.get(i++));
            }
            while (j < rSize) {
                array.set(k++, right.get(j++));
            }
        }
    }
}

