/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.Binding;
import com.api.jsonata4java.BindingType;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Expression {
    ExpressionsVisitor _eval = null;
    Expressions _expr = null;
    Map<String, DeclaredFunction> _functionMap = new HashMap<String, DeclaredFunction>();
    Map<String, MappingExpressionParser.ExprContext> _variableMap = new HashMap<String, MappingExpressionParser.ExprContext>();

    public static Expression jsonata(String expression) throws ParseException, IOException {
        return new Expression(expression);
    }

    public static void main(String[] args) {
        try {
            String exprString = "$sum(example.value)";
            String inputString = "{\"example\": [{\"value\": 4}, {\"value\": 7}, {\"value\": 13}]}";
            System.out.println("Expression is " + exprString);
            System.out.println("Input is " + inputString);
            Expression expression = Expression.jsonata(exprString);
            JsonNode obj = new ObjectMapper().readTree(inputString);
            JsonNode result = expression.evaluate(obj);
            System.out.println("Result is " + result);
            expression = Expression.jsonata("$a +$b()");
            expression.assign("a", "4");
            expression.assign("$b", "function(){1}");
            result = expression.evaluate(obj);
            System.out.println("Input is \"$a + $b()\" with assignments \"a\":4, \"$b\":\"function(){1}\"");
            System.out.println("Result is " + result);
            JsonNode bindingObj = new ObjectMapper().readTree("{\"a\":4, \"b\":\"function(){78}\"}");
            System.out.println("Input is \"$a + $b()\" with binding object: " + bindingObj.toString());
            System.out.println("Result is " + Expression.jsonata("$a + $b()").evaluate(obj, bindingObj));
            bindingObj = new ObjectMapper().readTree("{\"a\":4, \"b\":\"function($c){$c+78}\",\"c\":7}");
            System.out.println("Input is \"$a + $b($c)\" with binding object: " + bindingObj.toString());
            System.out.println("Result is " + Expression.jsonata("$a + $b($c)").evaluate(obj, bindingObj));
            try {
                expression = Expression.jsonata("$notafunction()");
                result = expression.evaluate(JsonNodeFactory.instance.objectNode());
                throw new Exception("Expression " + expression + " should have generated an exception");
            }
            catch (EvaluateRuntimeException ere) {
                System.out.println("Result is we got the expected EvaluateRuntimeException for " + ere.getLocalizedMessage());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvaluateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Expression(String expression) throws ParseException, IOException {
        this._expr = Expressions.parse(expression);
        this._eval = this._expr.getExpr();
    }

    public void assign(Binding binding) {
        if (binding.getType() == BindingType.VARIABLE) {
            this._variableMap.put(binding.getVarName(), binding.getExpression());
        } else {
            this._functionMap.put(binding.getVarName(), binding.getFunction());
        }
    }

    public void assign(String varname, String expression) throws ParseException, IOException {
        Binding binding = new Binding(varname, expression);
        this.assign(binding);
    }

    public JsonNode evaluate(JsonNode rootContext) throws EvaluateException, ParseException {
        ExpressionsVisitor eval = new ExpressionsVisitor(rootContext);
        Map<String, JsonNode> varMap = eval.getVariableMap();
        Map<String, DeclaredFunction> fctMap = eval.getFunctionMap();
        for (String key : this._variableMap.keySet()) {
            MappingExpressionParser.ExprContext ctx = this._variableMap.get(key);
            varMap.put(key, eval.visit(ctx));
        }
        for (String key : this._functionMap.keySet()) {
            DeclaredFunction fct = this._functionMap.get(key);
            fctMap.put(key, fct);
        }
        return eval.visit(this._expr.getTree());
    }

    public JsonNode evaluate(JsonNode rootContext, List<Binding> bindings) throws EvaluateException, ParseException {
        JsonNode result = null;
        for (Binding binding : bindings) {
            this.assign(binding);
        }
        result = this.evaluate(rootContext);
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext, JsonNode bindingObj) throws EvaluateException, ParseException, IOException {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Iterator<String> it = bindingObj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            JsonNode testObj = bindingObj.get(key);
            String expression = "";
            expression = !(testObj instanceof TextNode) ? ((Object)testObj).toString() : ((TextNode)testObj).asText();
            Binding binding = new Binding(key, expression);
            bindings.add(binding);
        }
        return this.evaluate(rootContext, bindings);
    }

    public void registerFunction(String fctName, String implementation) throws ParseException, IOException {
        Binding fctBinding = new Binding(fctName, implementation);
        this._functionMap.put(fctBinding.getVarName(), fctBinding.getFunction());
    }
}

