/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SiftFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$spread");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$spread");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$spread");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ObjectNode resultObject;
        block18: {
            MappingExpressionParser.ExprContext varid;
            ObjectNode object;
            MappingExpressionParser.ExprListContext exprList;
            boolean useContext;
            block17: {
                resultObject = new ObjectNode(JsonNodeFactory.instance);
                useContext = ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext || ctx.getParent() instanceof MappingExpressionParser.PathContext;
                JsonNode objNode = null;
                MappingExpressionParser.ExprValuesContext valuesCtx = ctx.exprValues();
                exprList = valuesCtx.exprList();
                objNode = useContext ? FunctionUtils.getContextVariable(expressionVisitor) : expressionVisitor.visit((ParseTree)exprList.expr(0));
                if (objNode == null || !objNode.isObject()) {
                    throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
                }
                object = (ObjectNode)objNode;
                varid = exprList.expr(useContext ? 0 : 1);
                if (!(varid instanceof MappingExpressionParser.Var_recallContext)) break block17;
                TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
                String varID = varid.getText();
                Function function = Constants.FUNCTIONS.get(varid.getText());
                if (function != null) {
                    Iterator it = object.fieldNames();
                    while (it.hasNext()) {
                        MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                        String key = (String)it.next();
                        JsonNode field = object.get(key);
                        JsonNode fctResult = FunctionUtils.processFctCallVariables(expressionVisitor, function, VAR_ID, callCtx, field, key, object);
                        if (fctResult == null || !fctResult.asBoolean()) continue;
                        resultObject.set(key, field);
                    }
                } else {
                    DeclaredFunction fct = expressionVisitor.functionMap.get(varID);
                    if (fct == null) {
                        throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared function.");
                    }
                    int varCount = fct.getVariableCount();
                    Iterator it = object.fieldNames();
                    while (it.hasNext()) {
                        JsonNode fctResult;
                        String key = (String)it.next();
                        JsonNode field = object.get(key);
                        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                        switch (varCount) {
                            case 1: {
                                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                                break;
                            }
                            case 2: {
                                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                                evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                break;
                            }
                            case 3: {
                                evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                                evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                                evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                            }
                        }
                        if ((fctResult = fct.invoke(expressionVisitor, evc)) == null || !fctResult.asBoolean()) continue;
                        resultObject.set(key, field);
                    }
                }
                break block18;
            }
            if (!(varid instanceof MappingExpressionParser.Function_declContext)) break block18;
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext fctBody = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody);
            int varCount = fct.getVariableCount();
            Iterator it = object.fieldNames();
            while (it.hasNext()) {
                JsonNode fctResult;
                String key = (String)it.next();
                JsonNode field = object.get(key);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext((MappingExpressionParser.ExprContext)ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                    }
                }
                if ((fctResult = fct.invoke(expressionVisitor, evc)) == null || !fctResult.asBoolean()) continue;
                resultObject.set(key, field);
            }
        }
        return resultObject;
    }

    @Override
    public String getSignature() {
        return "<x-:a<o>";
    }

    public void addObject(ArrayNode result, ObjectNode obj) {
        Iterator it = obj.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add((JsonNode)cell);
        }
    }
}

