/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.generated.MappingExpressionLexer;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;

public class Expressions {
    ParseTree tree = null;
    String expression = null;
    ExpressionsVisitor _eval = new ExpressionsVisitor(null, new FrameEnvironment(null));

    public static List<String> getRefsInExpression(Pattern refPattern, String expression) {
        Matcher matcher = refPattern.matcher(expression);
        LinkedList<String> matches = new LinkedList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        return matches;
    }

    public Expressions(ParseTree aTree, String anExpression) {
        this.tree = aTree;
        this.expression = anExpression;
    }

    public static Expressions parse(String mappingExpression) throws ParseException, IOException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(mappingExpression.getBytes("UTF-8"));
        CharStream input = CharStreams.fromStream(targetStream, Charset.forName("UTF-8"));
        MappingExpressionLexer lexer = new MappingExpressionLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        MappingExpressionParser parser = new MappingExpressionParser(tokens);
        MappingExpressionParser.ExprContext tree = null;
        BufferingErrorListener errorListener = new BufferingErrorListener();
        try {
            parser.removeErrorListeners();
            lexer.removeErrorListeners();
            parser.addErrorListener(errorListener);
            lexer.addErrorListener(errorListener);
            tree = parser.expr();
            if (errorListener.heardErrors()) {
                ParseTree error;
                if (tree != null && tree.getChildCount() > 0 && (error = tree.getChild(0)) instanceof ErrorNodeImpl && ((ErrorNodeImpl)error).getSymbol().getType() == 27) {
                    throw new EvaluateRuntimeException("The symbol \"~>\" cannot be used as a unary operator");
                }
                throw new ParseException(errorListener.getErrorsAsString());
            }
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage());
        }
        return new Expressions(tree, mappingExpression);
    }

    public JsonNode evaluate(JsonNode rootContext, long timeoutMS, int maxDepth) throws EvaluateException {
        JsonNode result = null;
        this._eval.setRootContext(rootContext);
        if (timeoutMS <= 0L) {
            throw new EvaluateException("The timeoutMS must be a positive number. Received " + timeoutMS);
        }
        if (maxDepth <= 0) {
            throw new EvaluateException("The maxDepth must be a positive number. Received " + maxDepth);
        }
        this._eval.timeboxExpression(timeoutMS, maxDepth);
        try {
            result = this._eval.visit(this.tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public JsonNode evaluate(JsonNode rootContext) throws EvaluateException {
        JsonNode result = null;
        this._eval.setRootContext(rootContext);
        try {
            result = this._eval.visitTree(this.tree);
        }
        catch (EvaluateRuntimeException e) {
            throw new EvaluateException(e.getMessage(), e);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public FrameEnvironment getEnvironment() {
        return this._eval.getEnvironment();
    }

    public ExpressionsVisitor getExpr() {
        return this._eval;
    }

    public void setExpr(ExpressionsVisitor expr) {
        this._eval = expr;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public void setTree(ParseTree parsetree) {
        this.tree = parsetree;
    }

    public void timeboxExpression(long timeoutMS, int maxDepth) {
        this._eval.timeboxExpression(timeoutMS, maxDepth);
    }

    public String toString() {
        return this.expression;
    }
}

