/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ValueNode;

public class NumberUtils {
    public static final ValueNode convertNumberToValueNode(String number) {
        NumericNode result = null;
        try {
            result = new LongNode(Long.valueOf(number));
        }
        catch (NumberFormatException e) {
            try {
                Double doubleValue = (double)Double.valueOf(number);
                if (!doubleValue.isInfinite() && !doubleValue.isNaN()) {
                    result = doubleValue - (double)doubleValue.longValue() == 0.0 ? new LongNode(doubleValue.longValue()) : new DoubleNode(doubleValue);
                }
                String msg = String.format("Number out of range: \"%s\"", number);
                throw new EvaluateRuntimeException(msg);
            }
            catch (NumberFormatException e2) {
                String msg = String.format("Unable to cast value to a number: \"%s\"", number);
                throw new EvaluateRuntimeException(msg);
            }
        }
        return result;
    }
}

