/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.FrameEnvironment;
import com.api.jsonata4java.expressions.NonNumericArrayIndexException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.generated.MappingExpressionBaseVisitor;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.BooleanUtils;
import com.api.jsonata4java.expressions.utils.Constants;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.api.jsonata4java.expressions.utils.NumberUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.text.StringEscapeUtils;

public class ExpressionsVisitor
extends MappingExpressionBaseVisitor<JsonNode> {
    private static final String _pattern = "#0.##";
    private static final DecimalFormat _decimalFormat = new DecimalFormat("#0.##");
    private static final String CLASS = ExpressionsVisitor.class.getName();
    public static final String ERR_MSG_INVALID_PATH_ENTRY = String.format("The literal value %s cannot be used as a step within a path expression", (Object[])null);
    public static final String ERR_NEGATE_NON_NUMERIC = "Cannot negate a non-numeric value";
    public static final String ERR_SEQ_LHS_INTEGER = "The left side of the range operator (..) must evaluate to an integer";
    public static final String ERR_SEQ_RHS_INTEGER = "The right side of the range operator (..) must evaluate to an integer";
    public static final String ERR_TOO_BIG = "The size of the sequence allocated by the range operator (..) must not exceed 1e6.  Attempted to allocate ";
    private static final Logger LOG = Logger.getLogger(CLASS);
    private static final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private FrameEnvironment _environment = null;
    private boolean checkRuntime = false;
    private int currentDepth = 0;
    private JsonNodeFactory factory = JsonNodeFactory.instance;
    private boolean firstStep = false;
    private boolean firstStepCons = false;
    private boolean inArrayConstructor = false;
    private boolean keepSingleton = false;
    private boolean lastStep = false;
    private boolean lastStepCons = false;
    private int maxDepth = -1;
    private long maxTime = 0L;
    private long startTime = new Date().getTime();
    private List<ParseTree> steps = new ArrayList<ParseTree>();
    private ParseTreeProperty<Integer> values = new ParseTreeProperty();

    private static boolean areJsonNodesEqual(JsonNode left, JsonNode right) {
        if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
            return left.asDouble() == right.asDouble();
        }
        if (left.isIntegralNumber() && right.isIntegralNumber()) {
            return left.asLong() == right.asLong();
        }
        if (left.isNull()) {
            return right.isNull();
        }
        if (right.isNull()) {
            return left.isNull();
        }
        if (left.isTextual() && right.isTextual()) {
            return left.asText().equals(right.asText());
        }
        if (left.isArray() && right.isArray()) {
            return left.equals((Object)right);
        }
        if (left.isObject() && right.isObject()) {
            return left.equals((Object)right);
        }
        if (left.isBoolean() && right.isBoolean()) {
            return left == right;
        }
        return false;
    }

    public static String castString(JsonNode node, boolean prettify) throws EvaluateRuntimeException {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case STRING: {
                return node.textValue();
            }
            case NUMBER: {
                if (!node.isDouble()) break;
                Double dValue = node.asDouble();
                if (Double.isInfinite(dValue) || Double.isNaN(dValue)) {
                    throw new EvaluateRuntimeException("Attempting to invoke string function on Infinity or NaN");
                }
                String test = dValue.toString();
                String strVal = "";
                int index = test.indexOf("E");
                String expStr = ".e+";
                if (index >= 0) {
                    int len;
                    int minusSize = dValue < 0.0 ? 1 : 0;
                    int exp = new Integer(test.substring(index + 1));
                    if (exp < 0) {
                        expStr = ".e";
                    }
                    if ((len = test.indexOf(".")) - minusSize + Math.abs(exp) <= 21) {
                        if (exp > 0) {
                            strVal = _decimalFormat.format(dValue);
                            return strVal;
                        }
                        if (exp > -7) {
                            strVal = new BigDecimal(dValue, new MathContext(15)).toString().toLowerCase();
                            if (strVal.indexOf(".") >= 0) {
                                while (strVal.endsWith("0") && strVal.length() > 0) {
                                    strVal = strVal.substring(0, strVal.length() - 1);
                                }
                            }
                            return strVal;
                        }
                    }
                    strVal = test.indexOf(".0E") > 0 ? test.substring(0, len) + expStr.substring(1) + test.substring(index + 1) : test.substring(0, index) + expStr + test.substring(index + 1);
                } else if (prettify) {
                    strVal = _decimalFormat.format(dValue);
                } else {
                    strVal = new BigDecimal(dValue, new MathContext(15)).toString().toLowerCase();
                    if (strVal.indexOf(".") >= 0) {
                        while (strVal.endsWith("0") && strVal.length() > 0) {
                            strVal = strVal.substring(0, strVal.length() - 1);
                        }
                    }
                }
                return strVal;
            }
        }
        try {
            if (prettify) {
                JsonElement jsonElt = JsonParser.parseString((String)objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
                return gson.toJson(jsonElt);
            }
            return objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new EvaluateRuntimeException("Failed to cast value " + node + " to a string. Reason: " + e.getMessage());
        }
    }

    public static ArrayNode ensureArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            return (ArrayNode)input;
        }
        return JsonNodeFactory.instance.arrayNode().add(input);
    }

    public static ArrayNode flatten(JsonNode arg, ArrayNode flattened) {
        if (flattened == null) {
            flattened = new ArrayNode(JsonNodeFactory.instance);
        }
        if (arg.isArray()) {
            Iterator it = ((ArrayNode)arg).iterator();
            while (it.hasNext()) {
                ExpressionsVisitor.flatten((JsonNode)it.next(), flattened);
            }
        } else {
            flattened.add(arg);
        }
        return flattened;
    }

    private static boolean isWholeNumber(double n) {
        return n == Math.rint(n) && !Double.isInfinite(n) && !Double.isNaN(n);
    }

    private static boolean isWholeNumber(JsonNode n) {
        if (n == null) {
            return false;
        }
        if (n.isInt() || n.isLong()) {
            return true;
        }
        return (n.isFloat() || n.isDouble()) && (double)n.asInt() == n.asDouble();
    }

    private static String sanitise(String str) {
        if (str.startsWith("`") && str.endsWith("`") || str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        str = StringEscapeUtils.unescapeJson((String)str);
        return str;
    }

    public static JsonNode unwrapArray(JsonNode input) {
        if (input == null) {
            return null;
        }
        if (input.isArray()) {
            if (input.size() == 1) {
                return input.get(0);
            }
            return input;
        }
        return input;
    }

    public ExpressionsVisitor() {
        this.setEnvironment(null);
        this.setRootContext(null);
    }

    public ExpressionsVisitor(JsonNode rootContext, FrameEnvironment environment) throws EvaluateRuntimeException {
        this.setEnvironment(environment);
        this.setRootContext(rootContext);
    }

    JsonNode append(JsonNode arg1, JsonNode arg2) {
        ArrayNode tempArray;
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        if (!arg1.isArray()) {
            tempArray = new ArrayNode(JsonNodeFactory.instance);
            tempArray.add(arg1);
            arg1 = tempArray;
        }
        if (!arg2.isArray()) {
            tempArray = new ArrayNode(JsonNodeFactory.instance);
            tempArray.add(arg2);
            arg2 = tempArray;
        }
        return ((ArrayNode)arg1).add((JsonNode)((ArrayNode)arg2));
    }

    private void checkRunaway() {
        if (this.checkRuntime && this.maxDepth != -1 && this.currentDepth > this.maxDepth) {
            throw new EvaluateRuntimeException("Stack overflow error: Check for non-terminating recursive function. Consider rewriting as tail-recursive.");
        }
        if (this.maxTime != 0L && new Date().getTime() - this.startTime > this.maxTime) {
            throw new EvaluateRuntimeException("Expression evaluation timeout: Check for infinite loop");
        }
    }

    private void evaluateEntry() {
        ++this.currentDepth;
        this.checkRunaway();
    }

    private void evaluateExit() {
        --this.currentDepth;
        this.checkRunaway();
    }

    public Stack<JsonNode> getContextStack() {
        return this._environment.getContextStack();
    }

    public DeclaredFunction getDeclaredFunction(String fctName) {
        return this._environment.getDeclaredFunction(fctName);
    }

    JsonNode getDescendants() {
        JsonNode startingElt;
        Object result = null;
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        if (!this._environment.isEmptyContext() && (startingElt = this._environment.peekContext()) != null) {
            this.traverseDescendants(startingElt, resultArray);
            result = resultArray.size() == 1 ? resultArray.get(0) : resultArray;
        }
        return result;
    }

    protected FrameEnvironment getEnvironment() {
        return this._environment;
    }

    public Function getJsonataFunction(String fctName) {
        return this._environment.getJsonataFunction(fctName);
    }

    public int getValue(ParseTree node) {
        return (Integer)this.values.get(node);
    }

    public JsonNode getVariable(String varName) {
        return this._environment.getVariable(varName);
    }

    boolean isSequence(JsonNode node) {
        return node != null && node instanceof SelectorArrayNode;
    }

    JsonNode lookup(JsonNode input, String key) {
        SelectorArrayNode result = null;
        if (input.isArray()) {
            result = new SelectorArrayNode(this.factory);
            for (int ii = 0; ii < input.size(); ++ii) {
                JsonNode res = this.lookup(input.get(ii), key);
                if (res == null) continue;
                if (res.isArray()) {
                    result.addAll((ArrayNode)res);
                    continue;
                }
                result.add(res);
            }
        } else if (input != null && input instanceof ObjectNode) {
            result = ((ObjectNode)input).get(key);
        }
        return result;
    }

    protected void processArrayContent(MappingExpressionParser.ExprOrSeqContext expr, ArrayNode output) {
        String testStr = "";
        for (ParseTree tree : expr.children) {
            JsonNode result;
            if (tree == null) {
                System.out.println("Got null in array values.");
                continue;
            }
            if (tree instanceof MappingExpressionParser.ExprOrSeqContext) {
                this.processArrayContent((MappingExpressionParser.ExprOrSeqContext)tree, output);
            }
            if (tree instanceof TerminalNodeImpl && ",[]".indexOf(testStr = tree.toString()) >= 0 || (result = this.visit(tree)) == null) continue;
            if (this.inArrayConstructor && result.isArray()) {
                output.addAll((ArrayNode)result);
                continue;
            }
            output.add(result);
        }
    }

    private List<Integer> resolveIndexes(List<Integer> input, int sizeOfSourceArray) {
        ArrayList<Integer> resolvedIndexes = new ArrayList<Integer>();
        for (int i : input) {
            if (i < 0) {
                resolvedIndexes.add(sizeOfSourceArray + i);
                continue;
            }
            resolvedIndexes.add(i);
        }
        Collections.sort(resolvedIndexes);
        return resolvedIndexes;
    }

    private JsonNode resolvePath(JsonNode lhs, MappingExpressionParser.ExprContext rhsCtx) {
        SelectorArrayNode output;
        String METHOD = "resolvePath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "resolvePath", new Object[]{lhs, rhsCtx.getText()});
        }
        if (lhs == null) {
            output = null;
        } else if (lhs.isArray()) {
            SelectorArrayNode arr;
            output = arr = new SelectorArrayNode(this.factory);
            for (JsonNode lhsE : lhs) {
                JsonNode rhsE = this.resolvePath(lhsE, rhsCtx);
                if (rhsE == null) continue;
                arr.addAsSelectionGroup(rhsE);
            }
        } else {
            this._environment.pushContext(lhs);
            output = this.visit((ParseTree)rhsCtx);
            this._environment.popContext();
        }
        SelectorArrayNode result = output;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "resolvePath", (Object)result);
        }
        return result;
    }

    public void setDeclaredFunction(String fctName, DeclaredFunction fctValue) {
        this._environment.setDeclaredFunction(fctName, fctValue);
    }

    protected void setEnvironment(FrameEnvironment environment) {
        if (environment == null) {
            environment = new FrameEnvironment(null);
        }
        this._environment = environment;
    }

    public void setJsonataFunction(String fctName, Function fctValue) {
        this._environment.setJsonataFunction(fctName, fctValue);
    }

    protected void setRootContext(JsonNode rootContext) {
        this._environment.clearContext();
        if (rootContext != null) {
            this._environment.pushContext(rootContext);
        }
    }

    public void setValue(ParseTree node, int value) {
        this.values.put(node, (Object)value);
    }

    public void setVariable(String varName, JsonNode varValue) throws EvaluateRuntimeException {
        this._environment.setVariable(varName, varValue);
    }

    public void timeboxExpression(long timeoutMS, int maxDepth) {
        if (timeoutMS > 0L && maxDepth > 0) {
            this.maxDepth = maxDepth;
            this.maxTime = timeoutMS;
            this.checkRuntime = true;
        }
    }

    void traverseDescendants(JsonNode input, ArrayNode results) {
        block3: {
            block4: {
                if (input == null) break block3;
                if (!input.isArray()) {
                    results.add(input);
                }
                if (!input.isArray()) break block4;
                for (JsonNode member : (ArrayNode)input) {
                    this.traverseDescendants(member, results);
                }
                break block3;
            }
            if (!input.isObject()) break block3;
            Iterator it = ((ObjectNode)input).fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.traverseDescendants(((ObjectNode)input).get(key), results);
            }
        }
    }

    public JsonNode visit(ParseTree tree) {
        JsonNode result = null;
        if (this.checkRuntime) {
            this.evaluateEntry();
        }
        if (this.steps.size() > 0 && tree.equals(this.steps.get(this.steps.size() - 1))) {
            this.lastStep = true;
        }
        result = (JsonNode)super.visit(tree);
        if (!this.keepSingleton && result != null && result instanceof SelectorArrayNode && result.size() == 1) {
            result = result.get(0);
        }
        if (this.checkRuntime) {
            this.evaluateExit();
        }
        return result;
    }

    @Override
    public JsonNode visitAddsub_op(MappingExpressionParser.Addsub_opContext ctx) {
        double result;
        JsonNode leftNode = this.visit((ParseTree)ctx.expr(0));
        JsonNode rightNode = this.visit((ParseTree)ctx.expr(1));
        if (leftNode == null || rightNode == null) {
            return null;
        }
        if (!leftNode.isNumber() || !rightNode.isNumber()) {
            throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
        }
        double left = leftNode.asDouble();
        double right = rightNode.asDouble();
        if (ctx.op.getType() == 31) {
            result = left + right;
        } else if (ctx.op.getType() == 32) {
            result = left - right;
        } else {
            throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
        }
        if (ExpressionsVisitor.isWholeNumber(result)) {
            return new LongNode((long)result);
        }
        return new DoubleNode(result);
    }

    @Override
    public JsonNode visitArray(MappingExpressionParser.ArrayContext ctx) {
        String METHOD = "visitArray";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray", new Object[]{ctx.getText()});
        }
        if (ctx.expr().size() != 2) {
            throw new EvaluateRuntimeException("invalid array expression");
        }
        ArrayNode sourceArray = ExpressionsVisitor.ensureArray(this.visit((ParseTree)ctx.expr(0)));
        if (sourceArray == null) {
            return null;
        }
        MappingExpressionParser.ExprContext indexContext = ctx.expr(1);
        ArrayList<Integer> indexesToReturn = new ArrayList<Integer>();
        ArrayNode output = JsonNodeFactory.instance.arrayNode();
        boolean isPredicate = false;
        boolean sourceIsSAN = false;
        List<Object> selGroups = new ArrayList();
        if (sourceArray instanceof SelectorArrayNode) {
            selGroups = ((SelectorArrayNode)sourceArray).getSelectionGroups();
        }
        for (int i = 0; i < (sourceIsSAN ? selGroups.size() : sourceArray.size()); ++i) {
            JsonNode e;
            JsonNode jsonNode = e = sourceIsSAN ? (JsonNode)selGroups.get(i) : sourceArray.get(i);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.logp(Level.FINEST, CLASS, "visitArray", "Evaluating array index expression '" + indexContext.getText() + "' against element at index " + i + " ('" + e + "') of source array");
            }
            this._environment.pushContext(e);
            Object indexesInContext = this.factory.arrayNode();
            indexesInContext = this.visit((ParseTree)indexContext);
            this._environment.popContext();
            if (indexesInContext == null) {
                isPredicate = true;
                continue;
            }
            if (indexesInContext.isBoolean()) {
                isPredicate = true;
                if (indexesInContext != BooleanNode.TRUE) continue;
                indexesToReturn.add(i);
                continue;
            }
            indexesInContext = ExpressionsVisitor.ensureArray((JsonNode)indexesInContext);
            Iterator iterator = indexesInContext.iterator();
            while (iterator.hasNext()) {
                JsonNode indexInContext = (JsonNode)iterator.next();
                if (indexInContext.isIntegralNumber()) {
                    indexesToReturn.add(indexInContext.asInt());
                    continue;
                }
                if (indexInContext.isFloatingPointNumber()) {
                    indexesToReturn.add((int)Math.floor(indexInContext.asDouble()));
                    continue;
                }
                if (indexInContext.isBoolean()) {
                    if (indexInContext.asBoolean()) {
                        return sourceArray;
                    }
                    if (indexesInContext.size() == 1) {
                        return null;
                    }
                    return sourceArray;
                }
                if (indexInContext.isArray()) {
                    ArrayNode indexArray = (ArrayNode)indexInContext;
                    boolean isOkay = false;
                    for (int j = 0; j < indexArray.size(); ++j) {
                        if (!indexArray.get(j).asBoolean()) continue;
                        isOkay = true;
                        break;
                    }
                    if (isOkay) {
                        return sourceArray;
                    }
                    return null;
                }
                throw new NonNumericArrayIndexException();
            }
            break;
        }
        if (!isPredicate && sourceArray instanceof SelectorArrayNode) {
            SelectorArrayNode sourceArraySel = (SelectorArrayNode)sourceArray;
            SelectorArrayNode resultAsSel = new SelectorArrayNode(this.factory);
            output = resultAsSel;
            block3: for (JsonNode group : sourceArraySel.getSelectionGroups()) {
                group = ExpressionsVisitor.ensureArray(group);
                List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, group.size());
                for (int index : resolvedIndexes) {
                    if (group.isArray()) {
                        JsonNode atIndex = group.get(index);
                        if (atIndex == null) continue block3;
                        resultAsSel.addAsSelectionGroup(atIndex);
                        continue;
                    }
                    if (index != 0) continue;
                    resultAsSel.addAsSelectionGroup(group);
                }
            }
        } else {
            output = this.factory.arrayNode();
            List<Integer> resolvedIndexes = this.resolveIndexes(indexesToReturn, sourceArray.size());
            for (int index : resolvedIndexes) {
                if (index < 0 || index >= sourceArray.size()) continue;
                output.add(sourceArray.get(index));
            }
        }
        if (output.size() == 0) {
            return null;
        }
        ArrayNode result = output;
        result = ExpressionsVisitor.unwrapArray((JsonNode)result);
        return result;
    }

    @Override
    public JsonNode visitArray_constructor(MappingExpressionParser.Array_constructorContext ctx) {
        String METHOD = "visitArray_constructor";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitArray_constructor", new Object[]{ctx.getText(), ctx.depth()});
        }
        this.inArrayConstructor = true;
        ArrayNode output = this.factory.arrayNode();
        if (ctx.exprOrSeqList() != null) {
            for (MappingExpressionParser.ExprOrSeqContext expr : ctx.exprOrSeqList().exprOrSeq()) {
                if (expr.seq() == null) {
                    this.processArrayContent(expr, output);
                    continue;
                }
                ArrayNode seq = (ArrayNode)this.visit((ParseTree)expr);
                if (seq == null) continue;
                output.addAll(seq);
            }
            this.inArrayConstructor = false;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitArray_constructor", output.toString());
        }
        return output;
    }

    @Override
    public JsonNode visitBoolean(MappingExpressionParser.BooleanContext ctx) {
        BooleanNode result = null;
        if (ctx.op.getType() == 12) {
            result = BooleanNode.TRUE;
        } else if (ctx.op.getType() == 13) {
            result = BooleanNode.FALSE;
        }
        return result;
    }

    @Override
    public JsonNode visitComp_op(MappingExpressionParser.Comp_opContext ctx) {
        BooleanNode result = null;
        JsonNode left = this.visit((ParseTree)ctx.expr(0));
        JsonNode right = this.visit((ParseTree)ctx.expr(1));
        if (left == null && right == null) {
            return BooleanNode.FALSE;
        }
        boolean lIsComparable = false;
        boolean rIsComparable = false;
        if (left != null && right != null) {
            JsonNodeType ltype = left.getNodeType();
            JsonNodeType rtype = right.getNodeType();
            lIsComparable = ltype == JsonNodeType.NULL || ltype == JsonNodeType.STRING || ltype == JsonNodeType.NUMBER;
            boolean bl = rIsComparable = rtype == JsonNodeType.NULL || rtype == JsonNodeType.STRING || rtype == JsonNodeType.NUMBER;
        }
        if (ctx.op.getType() == 34) {
            if (left == null && right != null) {
                return BooleanNode.FALSE;
            }
            if (left != null && right == null) {
                return BooleanNode.FALSE;
            }
            if (left.getNodeType() == right.getNodeType()) {
                return ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (!lIsComparable || !rIsComparable) {
                return null;
            }
            return BooleanNode.FALSE;
        }
        if (ctx.op.getType() == 35) {
            if (left == null && right != null) {
                return BooleanNode.TRUE;
            }
            if (left != null && right == null) {
                return BooleanNode.TRUE;
            }
            if (left.getNodeType() == right.getNodeType()) {
                return ExpressionsVisitor.areJsonNodesEqual(left, right) ? BooleanNode.FALSE : BooleanNode.TRUE;
            }
            if (!lIsComparable || !rIsComparable) {
                return null;
            }
            return BooleanNode.TRUE;
        }
        if (ctx.op.getType() == 36) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \"<\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() < right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() < right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else {
                    if (!lIsComparable || !rIsComparable) {
                        return null;
                    }
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) < 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 38) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \">\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() > right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() > right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else {
                    if (!lIsComparable || !rIsComparable) {
                        return null;
                    }
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) > 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 37) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \"<=\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() <= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() <= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else {
                    if (!lIsComparable || !rIsComparable) {
                        return null;
                    }
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \"<=\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) <= 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        } else if (ctx.op.getType() == 39) {
            if (left == null || right == null) {
                result = null;
            } else {
                if (left.isNull() || right.isNull()) {
                    throw new EvaluateRuntimeException("The expressions either side of operator \">=\" must evaluate to numeric or string values");
                }
                if (left.isBoolean() || right.isBoolean()) {
                    result = null;
                } else if (left.isFloatingPointNumber() || right.isFloatingPointNumber()) {
                    result = left.asDouble() >= right.asDouble() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else if (left.isIntegralNumber() && right.isIntegralNumber()) {
                    result = left.asLong() >= right.asLong() ? BooleanNode.TRUE : BooleanNode.FALSE;
                } else {
                    if (!lIsComparable || !rIsComparable) {
                        return null;
                    }
                    if (left.getNodeType() != right.getNodeType()) {
                        throw new EvaluateRuntimeException("The values " + left.toString() + " and " + right.toString() + " either side of operator \">=\" must be of the same data type");
                    }
                    result = left.asText().compareTo(right.asText()) >= 0 ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
            }
        }
        return result;
    }

    @Override
    public JsonNode visitConcat_op(MappingExpressionParser.Concat_opContext ctx) {
        JsonNode left = this.visit((ParseTree)ctx.expr(0));
        JsonNode right = this.visit((ParseTree)ctx.expr(1));
        String leftStr = left == null ? "" : (left != null && left.isDouble() ? ExpressionsVisitor.castString(left, false) : ExpressionsVisitor.castString(left, false));
        String rightStr = right == null ? "" : (right != null && right.isDouble() ? ExpressionsVisitor.castString(right, false) : ExpressionsVisitor.castString(right, false));
        TextNode result = new TextNode(leftStr + rightStr);
        return result;
    }

    @Override
    public JsonNode visitConditional(MappingExpressionParser.ConditionalContext ctx) {
        JsonNode cond = this.visit((ParseTree)ctx.expr(0));
        if (cond == null) {
            MappingExpressionParser.ExprContext ctx2 = ctx.expr(2);
            if (ctx2 != null) {
                return this.visit((ParseTree)ctx2);
            }
            return null;
        }
        if (cond instanceof BooleanNode) {
            MappingExpressionParser.ExprContext ctx1 = ctx.expr(1);
            MappingExpressionParser.ExprContext ctx2 = ctx.expr(2);
            if (ctx1 != null && ctx2 != null) {
                return BooleanUtils.convertJsonNodeToBoolean(cond) ? this.visit((ParseTree)ctx.expr(1)) : this.visit((ParseTree)ctx.expr(2));
            }
            if (BooleanUtils.convertJsonNodeToBoolean(cond)) {
                if (ctx1 != null) {
                    return this.visit((ParseTree)ctx1);
                }
                return null;
            }
            if (ctx2 != null) {
                return this.visit((ParseTree)ctx2);
            }
            return null;
        }
        return cond;
    }

    @Override
    public JsonNode visitContext_ref(MappingExpressionParser.Context_refContext ctx) {
        JsonNode result = null;
        if (ctx.getChildCount() > 0) {
            Object child0 = ctx.getChild(0);
            if (child0 instanceof TerminalNodeImpl) {
                if (((TerminalNodeImpl)child0).symbol.getText().equals("$")) {
                    JsonNode context = this.getVariable("$");
                    if (ctx.children.size() == 1) {
                        return context;
                    }
                    CommonToken token = null;
                    MappingExpressionParser.ExprContext expr = null;
                    switch (context.getNodeType()) {
                        case BINARY: 
                        case POJO: {
                            break;
                        }
                        case ARRAY: {
                            child0 = FunctionUtils.getArrayConstructorContext(ctx, (ArrayNode)context);
                            expr = new MappingExpressionParser.ArrayContext(ctx);
                            for (int i = 0; i < ctx.children.size(); ++i) {
                                expr.children.add(ctx.children.get(i));
                            }
                            expr.children.set(0, child0);
                            result = this.visit((ParseTree)expr);
                            break;
                        }
                        case BOOLEAN: {
                            token = context.asBoolean() ? (CommonToken)CommonTokenFactory.DEFAULT.create(12, context.asText()) : (CommonToken)CommonTokenFactory.DEFAULT.create(13, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                            MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                            bc.children.set(0, tn);
                            result = this.visit((ParseTree)bc);
                            break;
                        }
                        case MISSING: 
                        case NULL: {
                            token = (CommonToken)CommonTokenFactory.DEFAULT.create(15, null);
                            TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                            MappingExpressionParser.NullContext nc = new MappingExpressionParser.NullContext(ctx);
                            nc.children.set(0, tn);
                            result = this.visit((ParseTree)nc);
                            break;
                        }
                        case NUMBER: {
                            token = (CommonToken)CommonTokenFactory.DEFAULT.create(23, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                            MappingExpressionParser.NumberContext nc = new MappingExpressionParser.NumberContext(ctx);
                            nc.children.set(0, tn);
                            result = this.visit((ParseTree)nc);
                            break;
                        }
                        case OBJECT: {
                            child0 = FunctionUtils.getObjectConstructorContext(ctx, (ObjectNode)context);
                            expr = new MappingExpressionParser.PathContext(ctx);
                            for (int i = 0; i < ctx.children.size(); ++i) {
                                expr.children.add(ctx.children.get(i));
                            }
                            expr.children.set(0, child0);
                            result = this.visit((ParseTree)expr);
                            break;
                        }
                        default: {
                            token = (CommonToken)CommonTokenFactory.DEFAULT.create(14, context.asText());
                            TerminalNodeImpl tn = new TerminalNodeImpl((Token)token);
                            MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                            sc.children.set(0, tn);
                            result = this.visit((ParseTree)sc);
                            break;
                        }
                    }
                }
            } else {
                result = this.visit((ParseTree)child0);
            }
        }
        return result;
    }

    @Override
    public JsonNode visitDescendant(MappingExpressionParser.DescendantContext ctx) {
        JsonNode result;
        ArrayNode resultArray;
        block6: {
            MappingExpressionParser.ExprContext exprCtx;
            JsonNode descendants;
            block7: {
                block8: {
                    block5: {
                        resultArray = new ArrayNode(JsonNodeFactory.instance);
                        descendants = this.getDescendants();
                        exprCtx = ctx.expr();
                        if (descendants != null) break block5;
                        resultArray = null;
                        break block6;
                    }
                    if (descendants.isArray()) break block7;
                    if (exprCtx != null) break block8;
                    resultArray.add(descendants);
                    break block6;
                }
                result = this.visit((ParseTree)exprCtx);
                if (result == null) break block6;
                resultArray.add(result);
                break block6;
            }
            Iterator it = ((ArrayNode)descendants).iterator();
            while (it.hasNext()) {
                if (exprCtx == null) {
                    resultArray.add((JsonNode)it.next());
                    continue;
                }
                this._environment.pushContext((JsonNode)it.next());
                JsonNode result2 = null;
                if (exprCtx instanceof MappingExpressionParser.StringContext) {
                    CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(42, this.visit((ParseTree)exprCtx).asText());
                    TerminalNodeImpl node = new TerminalNodeImpl((Token)token);
                    MappingExpressionParser.IdContext idCtx = new MappingExpressionParser.IdContext(exprCtx);
                    idCtx.addChild((TerminalNode)node);
                    result2 = this.visit((ParseTree)idCtx);
                } else {
                    result2 = this.visit((ParseTree)exprCtx);
                }
                this._environment.popContext();
                if (result2 == null) continue;
                resultArray.add(result2);
            }
        }
        if (resultArray == null || resultArray.size() == 0) {
            return null;
        }
        result = ExpressionsVisitor.unwrapArray((JsonNode)resultArray);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitFct_chain(MappingExpressionParser.Fct_chainContext ctx) {
        JsonNode result = null;
        MappingExpressionParser.ExprContext exprObj = ctx.expr(1);
        if (!(exprObj instanceof MappingExpressionParser.Function_callContext)) {
            if (!(exprObj instanceof MappingExpressionParser.Var_recallContext)) throw new EvaluateRuntimeException("Expected a function but got " + ctx.expr(1).getText());
            String fctName = ((MappingExpressionParser.Var_recallContext)exprObj).VAR_ID().getText();
            DeclaredFunction declFct = this.getDeclaredFunction(fctName);
            if (declFct != null) return declFct.invoke(this, ctx.expr(1));
            Function function = this.getJsonataFunction(fctName);
            if (function == null) {
                function = Constants.FUNCTIONS.get(fctName);
            }
            if (function == null) throw new EvaluateRuntimeException("Unknown function: " + fctName);
            return function.invoke(this, (MappingExpressionParser.Function_callContext)ctx.expr(1));
        }
        JsonNode test = this.visit((ParseTree)ctx.expr(0));
        this._environment.pushContext(test);
        result = this.visit((ParseTree)ctx.expr(1));
        this._environment.popContext();
        return result;
    }

    @Override
    public JsonNode visitField_values(MappingExpressionParser.Field_valuesContext ctx) {
        ArrayNode resultArray = new ArrayNode(JsonNodeFactory.instance);
        ArrayNode valArray = new ArrayNode(JsonNodeFactory.instance);
        MappingExpressionParser.ExprContext exprCtx = ctx.expr();
        if (this._environment.isEmptyContext()) {
            return null;
        }
        JsonNode elt = this._environment.peekContext();
        if (elt == null || !elt.isObject()) {
            return null;
        }
        Iterator it = ((ObjectNode)elt).fieldNames();
        while (it.hasNext()) {
            JsonNode value = ((ObjectNode)elt).get((String)it.next());
            if (value.isArray()) {
                value = ExpressionsVisitor.flatten(value, null);
                Iterator it2 = ((ArrayNode)value).iterator();
                while (it2.hasNext()) {
                    valArray.add((JsonNode)it2.next());
                }
                continue;
            }
            valArray.add(value);
        }
        for (JsonNode value : valArray) {
            if (exprCtx == null) {
                resultArray.add(value);
                continue;
            }
            this._environment.pushContext(value);
            JsonNode result = this.visit((ParseTree)exprCtx);
            if (result != null) {
                resultArray.add(result);
            }
            this._environment.popContext();
        }
        if (resultArray.size() == 0) {
            return null;
        }
        JsonNode result = ExpressionsVisitor.unwrapArray((JsonNode)resultArray);
        return result;
    }

    @Override
    public JsonNode visitFieldList(MappingExpressionParser.FieldListContext ctx) {
        ObjectNode resultObject = new ObjectNode(JsonNodeFactory.instance);
        if (this._environment.isEmptyContext()) {
            return null;
        }
        JsonNode elt = this._environment.peekContext();
        if (elt == null || !elt.isObject()) {
            return null;
        }
        String key = "";
        JsonNode value = null;
        for (int i = 0; i < ctx.getChildCount(); i += 4) {
            key = ExpressionsVisitor.sanitise(((TerminalNodeImpl)ctx.getChild(i)).getText());
            value = this.visit(ctx.getChild(i + 2));
            if (value == null) continue;
            resultObject.set(key, value);
        }
        if (resultObject.size() == 0) {
            return null;
        }
        return resultObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitFunction_call(MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        String functionName = ctx.VAR_ID().getText();
        DeclaredFunction declFct = this.getDeclaredFunction(functionName);
        if (declFct != null) return declFct.invoke(this, ctx);
        Function function = this.getJsonataFunction(functionName);
        if (function == null) {
            function = Constants.FUNCTIONS.get(functionName);
        }
        if (function == null) throw new EvaluateRuntimeException("Unknown function: " + functionName);
        return function.invoke(this, ctx);
    }

    @Override
    public JsonNode visitFunction_decl(MappingExpressionParser.Function_declContext ctx) {
        String fctName = ctx.FUNCTIONID().getText();
        RuleContext expr = ctx.getRuleContext();
        JsonNode result = null;
        MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)expr;
        MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
        MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
        DeclaredFunction fct = new DeclaredFunction(varList, exprList);
        this.setDeclaredFunction(fctName, fct);
        return result;
    }

    @Override
    public JsonNode visitFunction_exec(MappingExpressionParser.Function_execContext ctx) {
        int exprListCount;
        JsonNode result = null;
        List<TerminalNode> varListCtx = ctx.varList().VAR_ID();
        List<MappingExpressionParser.ExprContext> exprValuesCtx = ctx.exprValues().exprList().expr();
        int varListCount = varListCtx.size();
        if (varListCount != (exprListCount = exprValuesCtx.size())) {
            throw new EvaluateRuntimeException("Expected equal counts for varibles (" + varListCount + ") and values (" + exprListCount + ")");
        }
        for (int i = 0; i < varListCount; ++i) {
            String varID = varListCtx.get(i).getText();
            JsonNode value = this.visit((ParseTree)exprValuesCtx.get(i));
            this.setVariable(varID, value);
        }
        MappingExpressionParser.ExprListContext exprListCtx = ctx.exprList();
        result = this.visit((ParseTree)exprListCtx);
        return result;
    }

    @Override
    public JsonNode visitId(MappingExpressionParser.IdContext ctx) {
        JsonNode context;
        String METHOD = "visitId";
        try {
            context = this._environment.peekContext();
        }
        catch (EmptyStackException ex) {
            return null;
        }
        String id = ExpressionsVisitor.sanitise(ctx.ID().getText());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitId", new Object[]{ctx.getText(), id, "(stack: " + context + ")"});
        }
        JsonNode result = null;
        result = context == null ? null : this.lookup(context, id);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitId", result);
        }
        return result;
    }

    @Override
    public JsonNode visitLogand(MappingExpressionParser.LogandContext ctx) {
        BooleanNode result = null;
        JsonNode left = this.visit((ParseTree)ctx.expr(0));
        JsonNode right = this.visit((ParseTree)ctx.expr(1));
        result = BooleanUtils.convertJsonNodeToBoolean(left) && BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        return result;
    }

    @Override
    public JsonNode visitLogor(MappingExpressionParser.LogorContext ctx) {
        BooleanNode result = null;
        JsonNode left = this.visit((ParseTree)ctx.expr(0));
        JsonNode right = this.visit((ParseTree)ctx.expr(1));
        result = BooleanUtils.convertJsonNodeToBoolean(left) || BooleanUtils.convertJsonNodeToBoolean(right) ? BooleanNode.TRUE : BooleanNode.FALSE;
        return result;
    }

    @Override
    public JsonNode visitMembership(MappingExpressionParser.MembershipContext ctx) {
        String METHOD = "visitMembership";
        JsonNode left = this.visit((ParseTree)ctx.expr(0));
        JsonNode right = this.visit((ParseTree)ctx.expr(1));
        if (left == null || right == null) {
            return null;
        }
        right = ExpressionsVisitor.ensureArray(right);
        left = ExpressionsVisitor.unwrapArray(left);
        BooleanNode result = BooleanNode.FALSE;
        Iterator elements = right.elements();
        while (elements.hasNext()) {
            JsonNode curElement = (JsonNode)elements.next();
            if (!ExpressionsVisitor.areJsonNodesEqual(left, curElement)) continue;
            result = BooleanNode.TRUE;
            break;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.logp(Level.FINEST, CLASS, "visitMembership", "is " + left + " (" + left.getNodeType() + ") in " + right + " (" + right.getNodeType() + ")? -> " + result);
        }
        return result;
    }

    @Override
    public JsonNode visitMuldiv_op(MappingExpressionParser.Muldiv_opContext ctx) {
        Double result;
        JsonNode leftNode = this.visit((ParseTree)ctx.expr(0));
        JsonNode rightNode = this.visit((ParseTree)ctx.expr(1));
        if (leftNode == null || rightNode == null) {
            return null;
        }
        if (!leftNode.isNumber() || !rightNode.isNumber()) {
            throw new EvaluateRuntimeException(ctx.op.getText() + " expects two numeric arguments");
        }
        double left = leftNode.asDouble();
        double right = rightNode.asDouble();
        if (ctx.op.getType() == 29) {
            result = left * right;
        } else if (ctx.op.getType() == 30) {
            if (right == 0.0) {
                return new DoubleNode(Double.POSITIVE_INFINITY);
            }
            result = left / right;
        } else if (ctx.op.getType() == 33) {
            if (right == 0.0) {
                return new DoubleNode(Double.POSITIVE_INFINITY);
            }
            result = left % right;
        } else {
            throw new EvaluateRuntimeException("Unrecognised token " + ctx.op.getText());
        }
        if (result.isInfinite() || result.isNaN()) {
            throw new EvaluateRuntimeException("Number out of range: \"null\"");
        }
        if (ExpressionsVisitor.isWholeNumber(result)) {
            return new LongNode(result.longValue());
        }
        return new DoubleNode(result.doubleValue());
    }

    @Override
    public JsonNode visitNull(MappingExpressionParser.NullContext ctx) {
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visitNumber(MappingExpressionParser.NumberContext ctx) {
        return NumberUtils.convertNumberToValueNode(ctx.NUMBER().getText());
    }

    @Override
    public JsonNode visitObject_constructor(MappingExpressionParser.Object_constructorContext ctx) {
        ObjectNode object = this.factory.objectNode();
        if (ctx.fieldList() == null) {
            return object;
        }
        List<TerminalNode> keyNodes = ctx.fieldList().STRING();
        List<MappingExpressionParser.ExprContext> valueNodes = ctx.fieldList().expr();
        if (keyNodes.size() != valueNodes.size()) {
            throw new EvaluateRuntimeException("Object key/value count mismatch!");
        }
        MappingExpressionParser.ExprContext valueNode = null;
        Object value = null;
        String fctName = null;
        String key = "";
        for (int i = 0; i < keyNodes.size(); ++i) {
            key = keyNodes.get(i).getText();
            key = ExpressionsVisitor.sanitise(key);
            valueNode = valueNodes.get(i);
            if (valueNode instanceof MappingExpressionParser.Function_declContext) {
                this.visit((ParseTree)valueNode);
                fctName = ((MappingExpressionParser.Function_declContext)valueNode).FUNCTIONID().getText();
                if (this.getDeclaredFunction(fctName) != null) {
                    value = new TextNode("");
                }
            } else if (valueNode instanceof MappingExpressionParser.Var_recallContext) {
                value = this.visit((ParseTree)valueNode);
                if (value == null) {
                    Function fct;
                    String varName = ((MappingExpressionParser.Var_recallContext)valueNode).VAR_ID().getText();
                    DeclaredFunction declFct = this.getDeclaredFunction(varName);
                    value = declFct != null ? new TextNode("") : ((fct = this.getJsonataFunction(varName)) != null ? new TextNode("") : null);
                }
            } else {
                Double d;
                value = this.visit((ParseTree)valueNode);
                if (value != null && value.isDouble() && (Double.isNaN(d = Double.valueOf(value.asDouble())) || Double.isInfinite(d))) {
                    throw new EvaluateRuntimeException("Number out of range: null");
                }
            }
            if (value == null) continue;
            object.set(key, value);
        }
        return object;
    }

    @Override
    public JsonNode visitParens(MappingExpressionParser.ParensContext ctx) {
        JsonNode result = null;
        FrameEnvironment oldEnvironment = this._environment;
        this._environment = new FrameEnvironment(this._environment);
        List<MappingExpressionParser.ExprContext> expressions = ctx.expr();
        for (int i = 0; i < expressions.size(); ++i) {
            result = this.visit((ParseTree)ctx.expr(i));
        }
        if (result instanceof SelectorArrayNode) {
            ArrayNode newResult = this.factory.arrayNode();
            newResult.addAll((ArrayNode)((SelectorArrayNode)result));
            result = newResult;
        }
        this._environment = oldEnvironment;
        return result;
    }

    @Override
    public JsonNode visitPath(MappingExpressionParser.PathContext ctx) {
        JsonNode result;
        String METHOD = "visitPath";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitPath", ctx.getText());
        }
        MappingExpressionParser.ExprContext lhsCtx = ctx.expr(0);
        MappingExpressionParser.ExprContext rhsCtx = ctx.expr(1);
        JsonNode lhs = null;
        if (lhsCtx instanceof MappingExpressionParser.StringContext) {
            CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(42, this.visit((ParseTree)lhsCtx).asText());
            TerminalNodeImpl node = new TerminalNodeImpl((Token)token);
            MappingExpressionParser.IdContext idCtx = new MappingExpressionParser.IdContext(lhsCtx);
            idCtx.addChild((TerminalNode)node);
            lhs = this.visit((ParseTree)idCtx);
        } else {
            lhs = this.visit((ParseTree)lhsCtx);
        }
        if (lhs == null || lhs.isNull()) {
            return null;
        }
        switch (lhs.getNodeType()) {
            case NUMBER: {
                lhs = this.factory.textNode(lhs.asText());
                break;
            }
            case BOOLEAN: 
            case NULL: {
                throw new EvaluateRuntimeException(String.format("The literal value %s cannot be used as a step within a path expression", lhs.toString()));
            }
        }
        if (rhsCtx == null) {
            result = lhs;
        } else {
            JsonNode rhs = null;
            if (rhsCtx instanceof MappingExpressionParser.StringContext) {
                CommonToken token = (CommonToken)CommonTokenFactory.DEFAULT.create(42, this.visit((ParseTree)rhsCtx).asText());
                TerminalNodeImpl node = new TerminalNodeImpl((Token)token);
                MappingExpressionParser.IdContext idCtx = new MappingExpressionParser.IdContext(rhsCtx);
                idCtx.addChild((TerminalNode)node);
                rhs = this.resolvePath(lhs, idCtx);
            } else {
                if (rhsCtx instanceof MappingExpressionParser.NumberContext) {
                    throw new EvaluateRuntimeException("The literal value " + this.visit((ParseTree)rhsCtx) + " cannot be used as a step within a path expression");
                }
                rhs = this.resolvePath(lhs, rhsCtx);
            }
            if (rhs == null) {
                result = null;
            } else if (rhs instanceof SelectorArrayNode) {
                if (rhs.size() == 0) {
                    return null;
                }
                if (this.firstStepCons && this.firstStep || this.lastStep && this.lastStepCons) {
                    List<JsonNode> cells = ((SelectorArrayNode)rhs).getSelectionGroups();
                    result = new ArrayNode(JsonNodeFactory.instance);
                    for (JsonNode cell : cells) {
                        ((ArrayNode)result).add(cell);
                    }
                    this.firstStepCons = false;
                } else {
                    result = rhs;
                }
            } else {
                result = rhs;
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitPath", result);
        }
        return result;
    }

    @Override
    public JsonNode visitRoot_path(MappingExpressionParser.Root_pathContext ctx) {
        String METHOD = "visitRoot_path";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(CLASS, "visitRoot_path", ctx.getText());
        }
        MappingExpressionParser.ExprContext lhsCtx = ctx.expr();
        Stack<JsonNode> tmpStack = new Stack<JsonNode>();
        for (int stackSize = this._environment.sizeContext(); stackSize > 1; --stackSize) {
            tmpStack.push(this._environment.popContext());
        }
        JsonNode result = null;
        result = lhsCtx == null ? this._environment.peekContext() : this.visit((ParseTree)lhsCtx);
        while (!tmpStack.isEmpty()) {
            this._environment.pushContext((JsonNode)tmpStack.pop());
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(CLASS, "visitRoot_path", result);
        }
        return result;
    }

    @Override
    public JsonNode visitSeq(MappingExpressionParser.SeqContext ctx) {
        JsonNode start = this.visit((ParseTree)ctx.expr(0));
        JsonNode end = this.visit((ParseTree)ctx.expr(1));
        if (start != null && !ExpressionsVisitor.isWholeNumber(start)) {
            throw new EvaluateRuntimeException(ERR_SEQ_LHS_INTEGER);
        }
        if (end != null && !ExpressionsVisitor.isWholeNumber(end)) {
            throw new EvaluateRuntimeException(ERR_SEQ_RHS_INTEGER);
        }
        ArrayNode result = this.factory.arrayNode();
        if (start != null && end != null) {
            int iStart = start.asInt();
            int iEnd = end.asInt();
            int count = iEnd - iStart + 1;
            if (iEnd > iStart && count > 10000000) {
                throw new EvaluateRuntimeException(ERR_TOO_BIG + count + ".");
            }
            for (int i = start.asInt(); i <= end.asInt(); ++i) {
                result.add((JsonNode)new LongNode((long)i));
            }
        }
        return result;
    }

    @Override
    public JsonNode visitString(MappingExpressionParser.StringContext ctx) {
        String val = ctx.getText();
        val = ExpressionsVisitor.sanitise(val);
        return TextNode.valueOf((String)val);
    }

    @Override
    public JsonNode visitTo_array(MappingExpressionParser.To_arrayContext ctx) {
        JsonNode result = null;
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.PathContext || expr instanceof MappingExpressionParser.Context_refContext) {
            JsonNode tmpResult = this.visit((ParseTree)expr);
            if (tmpResult instanceof SelectorArrayNode) {
                result = tmpResult;
            } else {
                result = JsonNodeFactory.instance.arrayNode();
                ((ArrayNode)result).add(this.visit((ParseTree)expr));
            }
        } else {
            result = this.visit((ParseTree)expr);
        }
        return result;
    }

    public JsonNode visitTree(ParseTree tree) {
        Double d;
        int treeSize = tree.getChildCount();
        this.steps.clear();
        for (int i = 0; i < treeSize; ++i) {
            this.steps.add(tree.getChild(i));
        }
        if (tree.getChild(0) instanceof MappingExpressionParser.Array_constructorContext) {
            this.firstStepCons = true;
        }
        if (tree.getChild(treeSize - 1) instanceof MappingExpressionParser.Array_constructorContext) {
            this.lastStepCons = true;
        }
        this.firstStep = tree.equals(this.steps.get(0));
        JsonNode result = this.visit(tree);
        if (result != null && result.isArray() && result.size() == 1 && ((ArrayNode)result).get(0).isArray()) {
            result = ((ArrayNode)result).get(0);
        }
        if (result != null && result.isDouble() && (Double.isInfinite(d = Double.valueOf(result.asDouble())) || Double.isNaN(d))) {
            result = JsonNodeFactory.instance.nullNode();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitUnary_op(MappingExpressionParser.Unary_opContext ctx) {
        DoubleNode result = null;
        JsonNode operand = this.visit((ParseTree)ctx.expr());
        if (ctx.op.getType() != 32) return null;
        if (operand == null) {
            return null;
        }
        if (operand.isFloatingPointNumber()) {
            return new DoubleNode(-operand.asDouble());
        }
        if (!operand.isIntegralNumber()) throw new EvaluateRuntimeException(ERR_NEGATE_NON_NUMERIC);
        return new LongNode(-operand.asLong());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode visitVar_assign(MappingExpressionParser.Var_assignContext ctx) {
        String varName = ctx.VAR_ID().getText();
        JsonNode result = null;
        MappingExpressionParser.ExprContext expr = ctx.expr();
        if (expr instanceof MappingExpressionParser.Function_declContext) {
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)expr;
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
            DeclaredFunction fct = new DeclaredFunction(varList, exprList);
            this.setDeclaredFunction(varName, fct);
            return result;
        } else {
            if (expr instanceof MappingExpressionParser.Function_callContext) {
                MappingExpressionParser.Function_callContext fctCallCtx = (MappingExpressionParser.Function_callContext)expr;
                String functionName = fctCallCtx.VAR_ID().getText();
                DeclaredFunction declFct = this.getDeclaredFunction(functionName);
                if (declFct == null) {
                    Function function = this.getJsonataFunction(functionName);
                    if (function == null) throw new EvaluateRuntimeException("Unknown function: " + functionName);
                    this.setJsonataFunction(varName, function);
                    return this.visit((ParseTree)expr);
                } else {
                    this.setDeclaredFunction(varName, declFct);
                }
                return this.visit((ParseTree)expr);
            }
            if (expr instanceof MappingExpressionParser.Fct_chainContext) {
                MappingExpressionParser.ExprContext exprCtx = ((MappingExpressionParser.Fct_chainContext)expr).expr(0);
                if (!(exprCtx instanceof MappingExpressionParser.Var_recallContext)) return result;
                String fctName = exprCtx.getText();
                DeclaredFunction declFct = this.getDeclaredFunction(fctName);
                if (declFct != null) {
                    this.setDeclaredFunction(varName, declFct);
                    return this.visit((ParseTree)((MappingExpressionParser.Fct_chainContext)expr).expr(1));
                }
                Function fct = this.getJsonataFunction(fctName);
                if (fct == null) return null;
                this.setJsonataFunction(varName, fct);
                return this.visit((ParseTree)((MappingExpressionParser.Fct_chainContext)expr).expr(1));
            }
            result = this.visit((ParseTree)expr);
            this.setVariable(varName, result);
        }
        return result;
    }

    @Override
    public JsonNode visitVar_recall(MappingExpressionParser.Var_recallContext ctx) {
        String varName = ctx.getText();
        JsonNode result = this.getVariable(varName);
        return result;
    }

    public static class SelectorArrayNode
    extends ArrayNode {
        private List<JsonNode> selectionGroups = new ArrayList<JsonNode>();

        public SelectorArrayNode(JsonNodeFactory nc) {
            super(nc);
        }

        public void addAsSelectionGroup(JsonNode group) {
            if (group.isArray()) {
                this.addAll((ArrayNode)group);
            } else {
                this.add(group);
            }
            this.selectionGroups.add(group);
        }

        public List<JsonNode> getSelectionGroups() {
            return Collections.unmodifiableList(this.selectionGroups);
        }
    }
}

