/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;

public class SplitFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$split");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$split");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$split");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$split");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$split");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SplitFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount >= 1 && argCount <= 3) {
            JsonNode argLimit;
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argCount < 2) {
                if (argString == null || argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            JsonNode argSeparator = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            int limit = -1;
            if (argSeparator == null || !argSeparator.isTextual()) {
                if (argString == null) {
                    if (useContext) {
                        throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                    }
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            if (argString == null) {
                return null;
            }
            if (!argString.isTextual()) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            String str = argString.textValue();
            String separator = argSeparator.textValue();
            if (argCount == 3 && (argLimit = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2)) != null) {
                if (argLimit.isNumber() && argLimit.asInt() >= 0) {
                    limit = argLimit.asInt();
                } else {
                    throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                }
            }
            result = JsonNodeFactory.instance.arrayNode();
            if (!str.isEmpty()) {
                String[] items = str.split(separator);
                for (int i = 0; i < items.length && (limit == -1 || i < limit); ++i) {
                    result.add(items[i]);
                }
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG4BADTYPE);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-(sf)n?:a<s>>";
    }
}

