/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;

public class SpreadFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$spread");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$spread");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$spread");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode result = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        NullNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SpreadFunction.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            if (argObject != null && !argObject.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        boolean[] argIsArray = new boolean[]{false};
        if (argCount == 1) {
            MappingExpressionParser.ExprContext exprCtx;
            if (!useContext && (argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0)) == null && (exprCtx = ctx.exprValues().exprList().expr(0)) instanceof MappingExpressionParser.Function_declContext) {
                argObject = new TextNode("");
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        }
        result = (ExpressionsVisitor.SelectorArrayNode)this.spread(result, (JsonNode)argObject, argIsArray);
        if (result != null && !argIsArray[0]) {
            JsonNode test = ExpressionsVisitor.unwrapArray((JsonNode)result);
            if (test.isArray() && test instanceof ExpressionsVisitor.SelectorArrayNode) {
                result = (ExpressionsVisitor.SelectorArrayNode)test;
            } else {
                return test;
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-:a<o>";
    }

    public void addObject(ExpressionsVisitor.SelectorArrayNode result, ObjectNode obj) {
        Iterator it = obj.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add((JsonNode)cell);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonNode spread(ExpressionsVisitor.SelectorArrayNode result, JsonNode argObject, boolean[] argIsArray) {
        if (argObject == null) {
            return null;
        }
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            if (obj.size() <= 0) return null;
            this.addObject(result, obj);
            return result;
        }
        if (argObject.isArray()) {
            argIsArray[0] = true;
            ArrayNode objArray = (ArrayNode)argObject;
            if (objArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < objArray.size(); ++i) {
                JsonNode node = objArray.get(i);
                if (node.isObject()) {
                    ObjectNode obj = (ObjectNode)node;
                    this.addObject(result, obj);
                    continue;
                }
                if (node.isArray()) {
                    for (JsonNode elt : (ArrayNode)node) {
                        this.concat(result, this.spread(result, elt, argIsArray));
                    }
                    continue;
                }
                result.add(node);
            }
            return result;
        }
        result.add(argObject);
        return result;
    }

    JsonNode append(JsonNode base, JsonNode appendage) {
        if (base == null) {
            return appendage;
        }
        if (appendage == null) {
            return base;
        }
        if (!base.isArray()) {
            ExpressionsVisitor.SelectorArrayNode newBase = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
            newBase.add((JsonNode)base);
            base = newBase;
        }
        if (!appendage.isArray()) {
            ExpressionsVisitor.SelectorArrayNode newAppendage = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
            newAppendage.add((JsonNode)appendage);
            appendage = newAppendage;
        }
        return this.concat((ArrayNode)base, (JsonNode)appendage);
    }

    ArrayNode concat(ArrayNode base, JsonNode appendage) {
        if (appendage.isArray()) {
            for (JsonNode elt : appendage) {
                base.add(elt);
            }
        } else {
            base.add(appendage);
        }
        return base;
    }
}

