/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.JSONataUtils;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;

public class SubstringFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 9146823646321165364L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$substring");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$substring");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$substring");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$substring");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$substring");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        Integer length;
        int start;
        String str;
        TextNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SubstringFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount >= 1 && argCount <= 3) {
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argCount == 1) {
                if (argString == null || argString.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                if (!argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            JsonNode argStart = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            if (argString == null) {
                if (argStart == null || argStart.isNumber()) {
                    return null;
                }
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            if (!argString.isTextual()) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            str = argString.textValue();
            if (argStart == null) {
                start = 0;
            } else {
                if (!argStart.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
                start = argStart.asInt();
            }
            if (argCount == 3) {
                JsonNode argLength = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2);
                if (argLength == null) {
                    length = null;
                } else {
                    if (!argLength.isNumber()) {
                        throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                    }
                    length = argLength.asInt();
                }
            } else {
                length = null;
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG4BADTYPE);
        }
        result = new TextNode(JSONataUtils.substr(str, start, length));
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-nn?:s>";
    }
}

