/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;

public class IndexOfFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 1821794638528005180L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$indexOf");
    public static final String ERR_ARG1_TYPE = String.format("Argument 1 of function \"%s\" must be an an array", "$indexOf");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$indexOf");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$indexOf");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        NullNode arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = IndexOfFunction.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            if (arg != null && !arg.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 2) {
            if (!useContext) {
                arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            JsonNode searchVar = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            if (arg == null || searchVar == null) {
                return new LongNode(-1L);
            }
            if (arg.isArray()) {
                ArrayNode array = (ArrayNode)arg;
                JsonNode val = null;
                for (int i = 0; i < array.size(); ++i) {
                    val = array.get(i);
                    if (val == null || !val.equals((Object)searchVar)) continue;
                    return new LongNode((long)i);
                }
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : (argCount == 1 ? ERR_ARG2BADTYPE : ERR_ARG3BADTYPE));
        }
        return new LongNode(-1L);
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<a-x:n>";
    }
}

