/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class KeysFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -6908272736871289545L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$keys");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$keys");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$keys");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ObjectNode result = new ObjectNode(JsonNodeFactory.instance);
        JsonNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = KeysFunction.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            if (argObject != null && !argObject.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argObject == null) {
            return null;
        }
        String key = "";
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            Iterator<String> it = obj.fieldNames();
            while (it.hasNext()) {
                key = it.next();
                if (result.get(key) != null) continue;
                result.put(key, true);
            }
        } else {
            if (!argObject.isArray()) return null;
            KeysFunction.findObjects((ArrayNode)argObject, result);
        }
        if (result.size() == 0) {
            return null;
        }
        ExpressionsVisitor.SelectorArrayNode output = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        Iterator<String> it = result.fieldNames();
        while (it.hasNext()) {
            output.add(it.next());
        }
        return ExpressionsVisitor.unwrapArray(output);
    }

    static void findObjects(ArrayNode array, ObjectNode result) {
        for (int i = 0; i < array.size(); ++i) {
            JsonNode arrayNode = array.get(i);
            if (arrayNode == null || arrayNode.isArray() || !arrayNode.isObject()) continue;
            KeysFunction.captureKeys((ObjectNode)arrayNode, result);
        }
    }

    static void captureKeys(ObjectNode argObject, ObjectNode result) {
        String key = null;
        ObjectNode obj = argObject;
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            key = it.next();
            if (result.get(key) != null) continue;
            result.put(key, true);
        }
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-:a<s>>";
    }
}

