/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class MergeFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -99966498930256770L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$merge");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$merge");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$merge");
    public static String ERR_ARG1_MUST_BE_OBJECT_ARRAY = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$merge");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        NullNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = MergeFunction.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            if (argArray != null && !argArray.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        String key = null;
        if (argArray == null) {
            return null;
        }
        if (argArray.isArray()) {
            ArrayNode array = (ArrayNode)argArray;
            int i = 0;
            while (i < array.size()) {
                JsonNode obj = array.get(i);
                if (!obj.isObject()) throw new EvaluateRuntimeException(ERR_ARG1_MUST_BE_OBJECT_ARRAY);
                ObjectNode cell = (ObjectNode)obj;
                Iterator it = cell.fieldNames();
                while (it.hasNext()) {
                    key = (String)it.next();
                    result.set(key, cell.get(key));
                }
                ++i;
            }
            return result;
        }
        if (!argArray.isObject()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        return (ObjectNode)argArray;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<a<o>:o>";
    }
}

