/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.RegularExpression;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.regex.Pattern;

public class ReplaceFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -647444066483284969L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$replace");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$replace");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$replace");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$replace");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$replace");
    public static String ERR_ARG5BADTYPE = String.format("Argument 5 of function %s does not match function signature", "$replace");
    public static final String ERR_MSG_ARG2_EMPTY_STR = String.format("Second argument of function %s cannot be an empty string", "$replace");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = ReplaceFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount < 1 || argCount > 4) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : (argCount == 1 ? ERR_ARG1BADTYPE : (argCount == 2 ? ERR_ARG2BADTYPE : ERR_ARG5BADTYPE)));
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) {
            if (argCount < 2) {
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            if (argCount != 2) return null;
            throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
        }
        if (argCount >= 2) {
            JsonNode argPattern = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            int limit = -1;
            if (argPattern == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            if (!argPattern.isTextual()) {
                if (!(argPattern instanceof POJONode)) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            if (argPattern.asText().isEmpty()) {
                throw new EvaluateRuntimeException(ERR_MSG_ARG2_EMPTY_STR);
            }
            if (argCount >= 3) {
                JsonNode argLimit;
                JsonNode argReplacement = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2);
                if (argReplacement == null) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                if (!argReplacement.isTextual()) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
                if (!argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                String str = argString.textValue();
                RegularExpression regex = argPattern instanceof POJONode ? (RegularExpression)((POJONode)argPattern).getPojo() : null;
                String pattern = regex != null ? regex.toString() : argPattern.textValue();
                String replacement = argReplacement.textValue();
                if (argCount == 4 && (argLimit = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 2 : 3)) != null) {
                    if (!argLimit.isNumber()) throw new EvaluateRuntimeException(ERR_ARG4BADTYPE);
                    if (argLimit.asInt() < 0) throw new EvaluateRuntimeException(ERR_ARG4BADTYPE);
                    limit = argLimit.asInt();
                }
                if (limit == -1) {
                    if (regex == null) return new TextNode(str.replaceAll(Pattern.quote(pattern), ReplaceFunction.jsonata2JavaReplacement(replacement)));
                    return new TextNode(regex.getPattern().matcher(str).replaceAll(ReplaceFunction.jsonata2JavaReplacement(replacement)));
                }
                String retString = new String(str);
                int i = 0;
                while (i < limit) {
                    retString = regex != null ? regex.getPattern().matcher(retString).replaceFirst(ReplaceFunction.jsonata2JavaReplacement(replacement)) : retString.replaceFirst(Pattern.quote(pattern), ReplaceFunction.jsonata2JavaReplacement(replacement));
                    ++i;
                }
                return new TextNode(retString);
            }
            if (argPattern == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            if (!argPattern.isTextual()) {
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            if (argString.isTextual()) return result;
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argString.isTextual()) return result;
        throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
    }

    public static String jsonata2JavaReplacement(String in) {
        return in.replaceAll("\\$\\$", "\\\\\\$").replaceAll("([^\\\\]|^)\\$([^0-9^<])", "$1\\\\\\$$2");
    }

    @Override
    public int getMaxArgs() {
        return 3;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-(sf)(sf)n?:s>";
    }
}

