/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.path;

import com.api.jsonata4java.expressions.BufferingErrorListener;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.path.PathExpressionVisitor;
import com.api.jsonata4java.expressions.path.generated.PathExpressionLexer;
import com.api.jsonata4java.expressions.path.generated.PathExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class PathExpression {
    private String expression;
    private ParseTree tree;

    private PathExpression(String expr, ParseTree tree) {
        this.expression = expr;
        this.tree = tree;
    }

    public JsonNode get(JsonNode jsonToRead, Integer indexVarValue) {
        PathExpressionVisitor.Getter visitor = new PathExpressionVisitor.Getter(jsonToRead, indexVarValue);
        return (JsonNode)visitor.visit(this.tree);
    }

    public JsonNode set(JsonNode jsonToModify, Integer indexVarValue, JsonNode valueToAssign) {
        PathExpressionVisitor.Setter visitor = new PathExpressionVisitor.Setter(jsonToModify, indexVarValue, valueToAssign);
        return (JsonNode)visitor.visit(this.tree);
    }

    public String toString() {
        return this.getExpression();
    }

    public String getExpression() {
        return this.expression;
    }

    public static PathExpression parse(String expr) throws ParseException {
        ANTLRInputStream input = new ANTLRInputStream(expr);
        PathExpressionLexer lexer = new PathExpressionLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PathExpressionParser parser = new PathExpressionParser((TokenStream)tokens);
        PathExpressionParser.ExprContext tree = null;
        BufferingErrorListener errorListener = new BufferingErrorListener();
        try {
            parser.removeErrorListeners();
            lexer.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            tree = parser.expr();
            if (errorListener.heardErrors()) {
                throw new ParseException(errorListener.getErrorsAsString());
            }
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage());
        }
        return new PathExpression(expr, (ParseTree)tree);
    }
}

