/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.BooleanUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;

public class BooleanFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = 5232965758998683140L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$boolean");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$boolean");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        BooleanNode result = null;
        NullNode arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = BooleanFunction.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            if (!(arg == null || arg.isNull() && argCount != 0)) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 0 && arg == null) {
            return null;
        }
        if (argCount == 1) {
            if (!useContext) {
                arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (arg != null) {
                result = BooleanUtils.convertJsonNodeToBoolean((JsonNode)arg) ? BooleanNode.TRUE : BooleanNode.FALSE;
            } else {
                MappingExpressionParser.ExprContext exprCtx = ctx.exprValues().exprList().expr(0);
                if (exprCtx instanceof MappingExpressionParser.Function_declContext) {
                    result = BooleanNode.FALSE;
                } else if (exprCtx != null) {
                    String functionName = exprCtx.getText();
                    if (expressionVisitor.getDeclaredFunction(functionName) != null) {
                        result = BooleanNode.FALSE;
                    } else if (expressionVisitor.getJsonataFunction(functionName) != null) {
                        result = BooleanNode.FALSE;
                    }
                }
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-:b>";
    }
}

