/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import com.api.jsonata4java.testerui.TesterUI;
import com.api.jsonata4java.testerui.TesterUIPerferences;
import com.api.jsonata4java.testerui.TesterUISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TesterUIFontChooser {
    private static final int FRAME_SIZE_X = 300;
    private static final int FRAME_SIZE_Y = 410;
    private static final int PAD = 5;
    private static final Insets INSETS = new Insets(5, 5, 5, 5);
    private final TesterUI ui;
    private final TesterUISettings settings;
    private final TesterUIPerferences prefui;
    private Font newFont;
    private final JFrame frame = new JFrame("JSONata4Java Font");
    private final DefaultListModel<String> nameListModel = new DefaultListModel();
    private final JList<String> nameList = new JList<String>(this.nameListModel);
    private final JScrollPane nameSp = new JScrollPane(this.nameList);
    private final JComboBox<FontStyle> styleBox = new JComboBox<FontStyle>(FontStyle.values());
    private final DefaultComboBoxModel<Integer> sizeBoxModel = new DefaultComboBoxModel();
    private final JComboBox<Integer> sizeBox = new JComboBox<Integer>(this.sizeBoxModel);
    private final JPanel inputPanel = new JPanel();
    private final JPanel southPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private static final int[] fontSizes = new int[]{8, 9, 10, 12, 14, 16, 18, 24, 32, 48, 64};

    public TesterUIFontChooser(TesterUI ui, TesterUISettings settings, TesterUIPerferences prefui) {
        this.ui = ui;
        this.settings = settings;
        this.prefui = prefui;
    }

    public void open() {
        this.configureComponents();
        this.buildLayout();
        this.frame.setVisible(true);
    }

    protected void configureComponents() {
        this.frame.setLayout(new BorderLayout(0, 0));
        this.frame.setSize(300, 410);
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TesterUIFontChooser.this.cancel();
            }
        });
        this.inputPanel.setLayout(new GridBagLayout());
        this.southPanel.setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : ge.getAvailableFontFamilyNames()) {
            this.nameListModel.addElement(name);
        }
        this.nameList.setSelectedIndex(0);
        this.nameList.setSelectionMode(0);
        this.nameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                TesterUIFontChooser.this.fontChanged();
            }
        });
        this.nameList.setSelectedValue(this.settings.getFont().getFontName(), true);
        this.nameSp.setMinimumSize(new Dimension(100, 100));
        for (int i = 0; i < fontSizes.length; ++i) {
            this.sizeBoxModel.addElement(fontSizes[i]);
        }
        this.styleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TesterUIFontChooser.this.fontChanged();
            }
        });
        this.styleBox.setSelectedIndex(this.settings.getFont().getStyle());
        this.sizeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TesterUIFontChooser.this.fontChanged();
            }
        });
        this.sizeBox.setSelectedItem(this.settings.getFont().getSize());
    }

    protected void buildLayout() {
        int x = 1;
        int y = 1;
        this.inputPanel.add((Component)new JLabel("Name"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.nameSp, new GridBagConstraints(x++, y++, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Style"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add(this.styleBox, new GridBagConstraints(x++, y++, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Size"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add(this.sizeBox, new GridBagConstraints(x++, y++, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.southPanel.add((Component)this.buttonsPanel, "South");
        this.frame.add((Component)this.inputPanel, "North");
        this.frame.add((Component)this.southPanel, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUIFontChooser.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUIFontChooser.this.cancel();
            }
        });
    }

    private void ok() {
        this.settings.setFont(this.newFont);
        this.prefui.setFont(this.newFont);
        this.frame.dispose();
    }

    private void cancel() {
        this.ui.setFont(this.settings.getFont());
        this.frame.dispose();
    }

    private void fontChanged() {
        String name = this.nameList.getSelectedValue();
        FontStyle style = (FontStyle)((Object)this.styleBox.getSelectedItem());
        Integer size = (Integer)this.sizeBox.getSelectedItem();
        if (name != null && style != null && size != null) {
            this.newFont = new Font(name, style.ordinal(), size);
            this.ui.setFont(this.newFont);
        }
    }

    private static enum FontStyle {
        PLAIN,
        BOLD,
        ITALIC;

    }
}

