/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;

public class ReverseFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$reverse");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$reverse");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$reverse");
    public static String ERR_ARG1_MUST_BE_ARRAY = String.format("Argument 1 of function \"%s\" must be an an array", "$reverse");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        NullNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = ReverseFunction.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            if (argArray != null && !argArray.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argArray == null) {
            return null;
        }
        if (argArray.isArray()) {
            ArrayNode array = (ArrayNode)argArray;
            for (int i = array.size() - 1; i >= 0; --i) {
                result.add(array.get(i));
            }
            return result;
        } else {
            if (!argArray.isNull()) throw new EvaluateRuntimeException(ERR_ARG1_MUST_BE_ARRAY);
            result.add((JsonNode)argArray);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<a:a>";
    }
}

