/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class MergeFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$merge");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$merge");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$merge");
    public static String ERR_ARG1_MUST_BE_OBJECT_ARRAY = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$merge");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        switch (argCount) {
            case 0: {
                if (arg != null) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            case 1: {
                if (arg == null) {
                    return null;
                }
                if (arg.isArray()) {
                    result = this.mergeArray(arg);
                    break;
                }
                if (arg.isObject()) {
                    result = (ObjectNode)arg;
                    break;
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            default: {
                if (ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
        }
        return result;
    }

    private JsonNode mergeArray(JsonNode arg) {
        ObjectNode arrayResult = JsonNodeFactory.instance.objectNode();
        ArrayNode array = (ArrayNode)arg;
        for (int i = 0; i < array.size(); ++i) {
            JsonNode obj = array.get(i);
            if (obj.isObject()) {
                ObjectNode cell = (ObjectNode)obj;
                Iterator it = cell.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    arrayResult.set(key, cell.get(key));
                }
                continue;
            }
            throw new EvaluateRuntimeException(ERR_ARG1_MUST_BE_OBJECT_ARRAY);
        }
        return arrayResult;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<a<o>:o>";
    }
}

