/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class SeerApiJacksonConverter
implements Converter {
    private static final String MIME_TYPE = "application/json; charset=UTF-8";
    private final ObjectMapper _mapper = new ObjectMapper();

    public SeerApiJacksonConverter() {
        this._mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this._mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this._mapper.setVisibilityChecker(this._mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this._mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this._mapper.setDateFormat((DateFormat)dateFormat);
    }

    public Object fromBody(TypedInput body, Type type) throws ConversionException {
        try {
            JavaType javaType = this._mapper.getTypeFactory().constructType(type);
            return this._mapper.readValue(body.in(), javaType);
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public TypedOutput toBody(Object object) {
        try {
            String json = this._mapper.writeValueAsString(object);
            return new TypedByteArray(MIME_TYPE, json.getBytes("UTF-8"));
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected ObjectMapper getMapper() {
        return this._mapper;
    }
}

