/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client.staging;

import com.imsweb.seerapi.client.staging.StagingData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SchemaLookup {
    private Map<String, String> _inputs = new HashMap<String, String>();

    public SchemaLookup() {
    }

    public SchemaLookup(Map<String, String> inputs) {
        this._inputs = inputs;
    }

    public SchemaLookup(String site, String histology) {
        this.setInput("site", site);
        this.setInput("hist", histology);
    }

    public Set<String> getAllowedKeys() {
        return null;
    }

    public Map<String, String> getInputs() {
        return this._inputs;
    }

    public String getInput(String key) {
        return this._inputs.get(key);
    }

    public void setInput(String key, String value) {
        if (this.getAllowedKeys() != null && !this.getAllowedKeys().contains(key)) {
            throw new IllegalStateException("The input key " + key + " is not allowed for lookups");
        }
        this._inputs.put(key, value);
    }

    protected void clearInputs() {
        this._inputs.clear();
    }

    public String getSite() {
        return this._inputs.get("site");
    }

    public void setSite(String site) {
        this._inputs.put("site", site);
    }

    public String getHistology() {
        return this._inputs.get("hist");
    }

    public void setHistology(String hist) {
        this._inputs.put("hist", hist);
    }

    public boolean hasDiscriminator() {
        boolean hasDiscriminator = false;
        for (Map.Entry<String, String> entry : this._inputs.entrySet()) {
            String value;
            String key = entry.getKey();
            if (StagingData.STANDARD_LOOKUP_KEYS.contains(key) || (value = entry.getValue()) == null || value.isEmpty()) continue;
            hasDiscriminator = true;
            break;
        }
        return hasDiscriminator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaLookup lookup = (SchemaLookup)o;
        return this._inputs.equals(lookup._inputs);
    }

    public int hashCode() {
        return this._inputs.hashCode();
    }
}

