/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client.staging.tnm;

import com.imsweb.seerapi.client.staging.StagingData;

public class TnmStagingData
extends StagingData {
    public static final String SEX_KEY = "sex";
    public static final String SSF25_KEY = "ssf25";
    public static final String INPUT_SSF_PREFIX = "ssf";

    public TnmStagingData() {
    }

    public TnmStagingData(String site, String hist) {
        super(site, hist);
    }

    public TnmStagingData(String site, String hist, String ssf25) {
        super(site, hist);
        this.setSsf(25, ssf25);
    }

    public String getInput(TnmInput key) {
        return this.getInput(key.toString());
    }

    public void setInput(TnmInput key, String value) {
        this.setInput(key.toString(), value);
    }

    public String getOutput(TnmOutput key) {
        return this.getOutput(key.toString());
    }

    public String getSsf(Integer id) {
        if (id < 1 || id > 25) {
            throw new IllegalStateException("Site specific factor must be between 1 and 25.");
        }
        return this.getInput(INPUT_SSF_PREFIX + id);
    }

    public void setSsf(Integer id, String ssf) {
        if (id < 1 || id > 25) {
            throw new IllegalStateException("Site specific factor must be between 1 and 25.");
        }
        this.setInput(INPUT_SSF_PREFIX + id, ssf);
    }

    public static class TnmStagingInputBuilder {
        private TnmStagingData _data = new TnmStagingData();

        public TnmStagingInputBuilder withSsf(Integer id, String ssf) {
            this._data.setSsf(id, ssf);
            return this;
        }

        public TnmStagingInputBuilder withInput(TnmInput key, String value) {
            this._data.setInput(key, value);
            return this;
        }

        public TnmStagingData build() {
            return this._data;
        }
    }

    public static enum TnmOutput {
        DERIVED_VERSION("derived_version"),
        CLIN_STAGE_GROUP("clin_stage_group"),
        PATH_STAGE_GROUP("path_stage_group"),
        COMBINED_STAGE_GROUP("combined_stage_group"),
        SOURCE_T("source_t"),
        COMBINED_T("combined_t"),
        SOURCE_N("source_n"),
        COMBINED_N("combined_n"),
        SOURCE_M("source_m"),
        COMBINED_M("combined_m");

        private final String _name;

        private TnmOutput(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static enum TnmInput {
        PRIMARY_SITE("site"),
        HISTOLOGY("hist"),
        BEHAVIOR("behavior"),
        GRADE("grade"),
        SEX("sex"),
        DX_YEAR("year_dx"),
        AGE_AT_DX("age_dx"),
        CLIN_STAGE_GROUP_DIRECT("clin_stage_group_direct"),
        PATH_STAGE_GROUP_DIRECT("path_stage_group_direct"),
        RX_SUMM_SURGERY("systemic_surg_seq"),
        RX_SUMM_RADIATION("radiation_surg_seq"),
        CLIN_T("clin_t"),
        CLIN_N("clin_n"),
        CLIN_M("clin_m"),
        PATH_T("path_t"),
        PATH_N("path_n"),
        PATH_M("path_m"),
        REGIONAL_NODES_POSITIVE("nodes_pos"),
        SSF1("ssf1"),
        SSF2("ssf2"),
        SSF3("ssf3"),
        SSF4("ssf4"),
        SSF5("ssf5"),
        SSF6("ssf6"),
        SSF7("ssf7"),
        SSF8("ssf8"),
        SSF9("ssf9"),
        SSF10("ssf10"),
        SSF11("ssf11"),
        SSF12("ssf12"),
        SSF13("ssf13"),
        SSF14("ssf14"),
        SSF15("ssf15"),
        SSF16("ssf16"),
        SSF17("ssf17"),
        SSF18("ssf18"),
        SSF19("ssf19"),
        SSF20("ssf20"),
        SSF21("ssf21"),
        SSF22("ssf22"),
        SSF23("ssf23"),
        SSF24("ssf24"),
        SSF25("ssf25");

        private final String _name;

        private TnmInput(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

