/*
 * Copyright (C) 2014 Information Management Services, Inc.
 */
package com.imsweb.staging.entities;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Property;

import com.imsweb.decisionengine.KeyMapping;

@JsonPropertyOrder({"from", "to"})
@Embedded
public class StagingKeyMapping implements KeyMapping {

    @Property("from")
    String _from;
    @Property("to")
    String _to;

    public StagingKeyMapping() {
    }

    public StagingKeyMapping(String from, String to) {
        _from = from;
        _to = to;
    }

    @Override
    @JsonProperty("from")
    public String getFrom() {
        return _from;
    }

    public void setFrom(String from) {
        _from = from;
    }

    @Override
    @JsonProperty("to")
    public String getTo() {
        return _to;
    }

    public void setTo(String to) {
        _to = to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        StagingKeyMapping that = (StagingKeyMapping)o;

        return Objects.equals(_from, that._from) && Objects.equals(_to, that._to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(_from, _to);
    }
}
