/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.util;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private boolean _isRunning;
    private long _elapsedNanos;
    private long _startTick;

    public static Stopwatch create() {
        return new Stopwatch().start();
    }

    private Stopwatch() {
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public Stopwatch start() {
        if (this.isRunning()) {
            throw new IllegalStateException("This stopwatch is already running.");
        }
        this._isRunning = true;
        this._startTick = System.nanoTime();
        return this;
    }

    public Stopwatch stop() {
        long tick = System.nanoTime();
        if (!this.isRunning()) {
            throw new IllegalStateException("This stopwatch is already stopped.");
        }
        this._isRunning = false;
        this._elapsedNanos += tick - this._startTick;
        return this;
    }

    public Stopwatch reset() {
        this._elapsedNanos = 0L;
        this._isRunning = false;
        return this;
    }

    private long elapsedNanos() {
        return this._isRunning ? System.nanoTime() - this._startTick + this._elapsedNanos : this._elapsedNanos;
    }

    public long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit unit = Stopwatch.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return String.format(Locale.ROOT, "%.4g", value) + " " + Stopwatch.abbreviate(unit);
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }
}

