/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.FormattedDate;
import infobip.api.model.sms.mt.logs.SMSLogsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetSentSmsLogs {
    private final Configuration configuration;

    public GetSentSmsLogs(Configuration configuration) {
        this.configuration = configuration;
    }

    public SMSLogsResponse execute(String from, String to, String[] bulkId, String[] messageId, String generalStatus, FormattedDate sentSince, FormattedDate sentUntil, Integer limit, String mcc, String mnc) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter(new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).build();
        GetSentSmsLogsService service = restAdapter.create(GetSentSmsLogsService.class);
        return service.execute(from, to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit, mcc, mnc);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            @Override
            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetSentSmsLogs.this.configuration != null && GetSentSmsLogs.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetSentSmsLogs.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetSentSmsLogsService {
        @GET(value="/sms/1/logs")
        public SMSLogsResponse execute(@Query(value="from") String var1, @Query(value="to") String var2, @Query(value="bulkId") String[] var3, @Query(value="messageId") String[] var4, @Query(value="generalStatus") String var5, @Query(value="sentSince") FormattedDate var6, @Query(value="sentUntil") FormattedDate var7, @Query(value="limit") Integer var8, @Query(value="mcc") String var9, @Query(value="mnc") String var10);
    }
}

