/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.model.sms.mt.send.SMSResponse;
import infobip.api.model.sms.mt.send.textual.SMSTextualRequest;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.GsonConverter;
import retrofit.http.Body;
import retrofit.http.POST;

public class SendSingleTextualSms {
    private final Configuration configuration;

    public SendSingleTextualSms(Configuration configuration) {
        this.configuration = configuration;
    }

    public SMSResponse execute(SMSTextualRequest bodyObject) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter(new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).build();
        SendSingleTextualSmsService service = restAdapter.create(SendSingleTextualSmsService.class);
        return service.execute(bodyObject);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            @Override
            public void intercept(RequestInterceptor.RequestFacade request) {
                if (SendSingleTextualSms.this.configuration != null && SendSingleTextualSms.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", SendSingleTextualSms.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface SendSingleTextualSmsService {
        @POST(value="/sms/1/text/single")
        public SMSResponse execute(@Body SMSTextualRequest var1);
    }
}

