/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.config;

import infobip.api.config.Configuration;
import javax.xml.bind.DatatypeConverter;

public class BasicAuthConfiguration
extends Configuration {
    private final String username;
    private final String password;

    public BasicAuthConfiguration(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
    }

    public BasicAuthConfiguration(String username, String password) {
        this.baseUrl = "https://api.infobip.com";
        this.username = username;
        this.password = password;
    }

    @Override
    public String getAuthorizationHeader() {
        return "Basic " + this.encodeBase64();
    }

    private String encodeBase64() {
        String userPass = this.username + ":" + this.password;
        return DatatypeConverter.printBase64Binary((byte[])userPass.getBytes());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

