/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.model.account.AccountBalance;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;

public class GetAccountBalance {
    private final Configuration configuration;

    public GetAccountBalance(Configuration configuration) {
        this.configuration = configuration;
    }

    public AccountBalance execute() {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).build();
        GetAccountBalanceService service = (GetAccountBalanceService)restAdapter.create(GetAccountBalanceService.class);
        return service.execute();
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetAccountBalance.this.configuration != null && GetAccountBalance.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetAccountBalance.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetAccountBalanceService {
        @GET(value="/account/1/balance")
        public AccountBalance execute();
    }
}

