/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.model.sms.mt.reports.SMSReportResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetSentSmsDeliveryReports {
    private final Configuration configuration;

    public GetSentSmsDeliveryReports(Configuration configuration) {
        this.configuration = configuration;
    }

    public SMSReportResponse execute(String bulkId, String messageId, Integer limit) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).build();
        GetSentSmsDeliveryReportsService service = (GetSentSmsDeliveryReportsService)restAdapter.create(GetSentSmsDeliveryReportsService.class);
        return service.execute(bulkId, messageId, limit);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetSentSmsDeliveryReports.this.configuration != null && GetSentSmsDeliveryReports.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetSentSmsDeliveryReports.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetSentSmsDeliveryReportsService {
        @GET(value="/sms/1/reports")
        public SMSReportResponse execute(@Query(value="bulkId") String var1, @Query(value="messageId") String var2, @Query(value="limit") Integer var3);
    }
}

