package infobip.api.client;

import infobip.api.config.Configuration;
import infobip.api.model.sms.mo.reports.MOReportResponse;
import com.google.gson.GsonBuilder;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

/**
 * This is a generated class and is not intended for modification!
 * TODO: Point to Github contribution instructions
 */
public class GetReceivedMessages {
    private final Configuration configuration;

    public GetReceivedMessages(Configuration configuration) {
        this.configuration = configuration;
    }

    interface GetReceivedMessagesService {
        @GET("/sms/1/inbox/reports")
        MOReportResponse execute(@Query("limit") java.lang.Integer limit);
    }
    public MOReportResponse execute(java.lang.Integer limit) {
        RestAdapter restAdapter = new RestAdapter.Builder()
                .setEndpoint(configuration.getBaseUrl())
                .setRequestInterceptor(getRequestInterceptor())
                .setConverter(new GsonConverter(new GsonBuilder()
                						.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ")
                						.create()))
                .build();
        GetReceivedMessagesService service = restAdapter.create(GetReceivedMessagesService.class);
        return service.execute(limit);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor() {
            @Override
            public void intercept(RequestFacade request) {
                if (configuration != null && configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }
}