/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx;

import com.intel.sgx.collateral.Collateral;
import com.intel.sgx.identity.QveIdentity;
import com.intel.sgx.result.SgxDcapQuoteVerifyResult;
import com.intel.sgx.result.TeeDcapQuoteVerifyResult;
import com.intel.sgx.result.supplementalResult;

public class SgxDcapVerifyQuoteJNI {
    static {
        try {
            System.loadLibrary("jni_dcap_quoteverify");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public QveIdentity sgxQvGetQveIdentity() {
        QveIdentity qveidentity = this.sgx_qv_get_qve_identity();
        return qveidentity;
    }

    public int sgxQvSetPath(int type, String path) {
        return this.sgx_qv_set_path(type, path);
    }

    public int sgxQvSetEnclaveLoadPolicy(int policy) {
        return this.sgx_qv_set_enclave_load_policy(policy);
    }

    public SgxDcapQuoteVerifyResult sgxQvVerifyQuote(byte[] quoteBytes) {
        long expireTime = System.currentTimeMillis() / 1000L;
        return this.sgxQvVerifyQuote(quoteBytes, expireTime);
    }

    public SgxDcapQuoteVerifyResult sgxQvVerifyQuote(byte[] quoteFilePath, long expireTime) {
        return this.sgxQvVerifyQuote(quoteFilePath, null, null, null, null, null, null, null, expireTime);
    }

    public SgxDcapQuoteVerifyResult sgxQvVerifyQuote(byte[] quoteBytes, byte[] pckBytes, byte[] pckIssuerBytes, byte[] tcbBytes, byte[] tcbIssuerBytes, byte[] qeIdentityBytes, byte[] qeIdentityIssuerBytes, byte[] rootCaBytes, long expirationData) {
        return this.sgx_qv_verify_quote(quoteBytes, pckBytes, pckIssuerBytes, tcbBytes, tcbIssuerBytes, qeIdentityBytes, qeIdentityIssuerBytes, rootCaBytes, expirationData);
    }

    public TeeDcapQuoteVerifyResult tee_verify_quote(byte[] quoteBytes) {
        long expireTime = System.currentTimeMillis() / 1000L;
        short default_version = 0;
        int default_suppl_size = 0;
        return this.tee_verify_quote(quoteBytes, expireTime, default_version, default_suppl_size);
    }

    public TeeDcapQuoteVerifyResult tee_verify_quote(byte[] quoteBytes, short version, int suppl_size) {
        long expireTime = System.currentTimeMillis() / 1000L;
        return this.tee_verify_quote(quoteBytes, expireTime, version, suppl_size);
    }

    public TeeDcapQuoteVerifyResult tee_verify_quote(byte[] quoteBytes, long expireTime, short version, int suppl_size) {
        return this.tee_verify_quote(quoteBytes, null, null, null, null, null, null, null, expireTime, version, suppl_size);
    }

    public Collateral teeQvGetCollateral(byte[] quoteBytes) {
        return this.tee_qv_get_collateral(quoteBytes);
    }

    private native SgxDcapQuoteVerifyResult sgx_qv_verify_quote(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, long var9);

    private native QveIdentity sgx_qv_get_qve_identity();

    private native int sgx_qv_set_path(int var1, String var2);

    private native int sgx_qv_set_enclave_load_policy(int var1);

    private native Collateral tee_qv_get_collateral(byte[] var1);

    private native TeeDcapQuoteVerifyResult tee_verify_quote(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, long var9, short var11, int var12);

    private native supplementalResult tee_get_supplemental_data_version_and_size(byte[] var1);
}

