/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx;

import com.intel.sgx.SgxDcapVerifyQuoteJNI;
import com.intel.sgx.collateral.Collateral;
import com.intel.sgx.result.SgxDcapQuoteVerifyResult;
import com.intel.sgx.result.TeeDcapQuoteVerifyResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;

public class Demo {
    public static void main(String[] args) throws IOException {
        byte[] quoteBytes = null;
        ArgumentParser parser = ArgumentParsers.newFor((String)"Demo").build().defaultHelp(true);
        parser.addArgument(new String[]{"-q", "--quote"}).required(true).type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead()).help("Please specify quote path to do verify");
        try {
            Namespace ns = parser.parseArgs(args);
            File quote = (File)ns.get("quote");
            quoteBytes = Files.readAllBytes(quote.toPath());
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
        System.out.println("Do quote verfication:\n");
        SgxDcapVerifyQuoteJNI Verifer = new SgxDcapVerifyQuoteJNI();
        SgxDcapQuoteVerifyResult result = Verifer.sgxQvVerifyQuote(quoteBytes);
        System.out.println("Quote verify result is " + result.getVerifyResult());
        if (result.getSupplement() != null) {
            byte[] cpu_svn = result.getSupplement().getTcb_cpusvn().getSvn();
            int i = 0;
            while (i < cpu_svn.length) {
                System.out.print(String.valueOf(cpu_svn[i]) + " ");
                ++i;
            }
        }
        System.out.println("Get quote collateral:\n");
        Collateral collat = Verifer.teeQvGetCollateral(quoteBytes);
        System.out.print(collat.toString());
        TeeDcapQuoteVerifyResult teeReult = Verifer.tee_verify_quote(quoteBytes, (short)3, 0);
        System.out.print(teeReult.getSupplement().toString());
    }
}

