/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.error;

import com.inversoft.error.Error;
import com.inversoft.json.ToString;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Errors {
    public final Map<String, List<Error>> fieldErrors = new LinkedHashMap<String, List<Error>>();
    public final List<Error> generalErrors = new LinkedList<Error>();

    public Errors add(Errors otherErrors) {
        if (otherErrors != null) {
            this.fieldErrors.putAll(otherErrors.fieldErrors);
            this.generalErrors.addAll(otherErrors.generalErrors);
        }
        return this;
    }

    public Errors addFieldError(String field, String code, String message, Map<String, Object> data, Object ... values) {
        List errors = this.fieldErrors.computeIfAbsent(field, k -> new LinkedList());
        errors.add(new Error(code, message, data, values));
        return this;
    }

    public Errors addFieldError(String field, String code, String message, Object ... values) {
        return this.addFieldError(field, code, message, null, values);
    }

    public Errors addGeneralError(String code, String message, Object ... values) {
        this.generalErrors.add(new Error(code, message, values));
        return this;
    }

    public boolean containsError(String codePrefix) {
        for (Error error : this.generalErrors) {
            if (!error.code.startsWith(codePrefix)) continue;
            return true;
        }
        for (List list : this.fieldErrors.values()) {
            for (Error error : list) {
                if (!error.code.startsWith(codePrefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean empty() {
        return this.generalErrors.isEmpty() && this.fieldErrors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Errors errors = (Errors)o;
        return this.fieldErrors.equals(errors.fieldErrors) && this.generalErrors.equals(errors.generalErrors);
    }

    public Error getFieldError(String field, String code) {
        List<Error> errors = this.fieldErrors.get(field);
        if (errors == null) {
            return null;
        }
        for (Error fieldError : errors) {
            if (!fieldError.code.equals(code)) continue;
            return fieldError;
        }
        return null;
    }

    public int hashCode() {
        int result = this.generalErrors.hashCode();
        result = 31 * result + this.fieldErrors.hashCode();
        return result;
    }

    public int size() {
        return this.generalErrors.size() + this.fieldErrors.values().stream().mapToInt(List::size).sum();
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

