/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.agent.SdkVersion;
import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.VbeProtocol;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.data.MetadataHolder;
import com.ionic.sdk.agent.data.MetadataMap;
import com.ionic.sdk.agent.hfp.Fingerprint;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceRequest;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceResponse;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceTransaction;
import com.ionic.sdk.agent.request.createkey.CreateKeysRequest;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.request.createkey.CreateKeysTransaction;
import com.ionic.sdk.agent.request.getkey.GetKeysRequest;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.agent.request.getkey.GetKeysTransaction;
import com.ionic.sdk.agent.request.getkeyspace.GetKeyspaceRequest;
import com.ionic.sdk.agent.request.getkeyspace.GetKeyspaceResponse;
import com.ionic.sdk.agent.request.getkeyspace.GetKeyspaceTransaction;
import com.ionic.sdk.agent.request.getresources.GetResourcesRequest;
import com.ionic.sdk.agent.request.getresources.GetResourcesResponse;
import com.ionic.sdk.agent.request.getresources.GetResourcesTransaction;
import com.ionic.sdk.agent.request.logmessage.LogMessagesRequest;
import com.ionic.sdk.agent.request.logmessage.LogMessagesResponse;
import com.ionic.sdk.agent.request.logmessage.LogMessagesTransaction;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysRequest;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysResponse;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysTransaction;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.device.profile.persistor.DeviceProfiles;
import com.ionic.sdk.device.profile.persistor.ProfilePersistor;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.IonicServerException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.util.ArrayList;
import java.util.List;

public class Agent
extends MetadataHolder
implements KeyServices {
    private boolean initialized = false;
    private List<DeviceProfile> deviceProfiles = new ArrayList<DeviceProfile>();
    private DeviceProfile activeProfile;
    private AgentConfig agentConfig;
    private Fingerprint fingerprint;
    private static long serverTimeOffsetMillis;
    public static final String KEYORIGIN_IONIC_KEYSERVER = "ionic-keyserver";

    public Agent() {
        this(new AgentConfig());
    }

    public Agent(Agent agent) {
        this(agent.getConfig());
        this.initialized = agent.initialized;
        this.deviceProfiles.addAll(agent.deviceProfiles);
        this.activeProfile = agent.activeProfile;
        this.fingerprint = agent.fingerprint;
        this.setMetadata(agent.getMetadata());
    }

    public Agent(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
    }

    public Agent(ProfilePersistor persistor) throws IonicException {
        this(new AgentConfig());
        this.initializeInternal(this.agentConfig, persistor, new MetadataMap(), new Fingerprint(null));
    }

    public Agent(DeviceProfiles deviceProfiles) throws IonicException {
        this(new AgentConfig());
        this.initializeInternal(this.agentConfig, deviceProfiles, new MetadataMap(), new Fingerprint(null));
    }

    public final Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public final void setFingerprint(String hfp) {
        this.fingerprint = new Fingerprint(hfp);
    }

    public final AgentConfig getConfig() {
        return new AgentConfig(this.agentConfig);
    }

    public final boolean hasAnyProfiles() {
        return !this.deviceProfiles.isEmpty();
    }

    @Override
    public final DeviceProfile getActiveProfile() {
        return this.activeProfile == null ? new DeviceProfile() : this.activeProfile;
    }

    @Override
    public final boolean hasActiveProfile() {
        return this.activeProfile != null;
    }

    public final boolean setActiveProfile(String deviceId) {
        return this.setActiveProfileInternal(deviceId);
    }

    private boolean setActiveProfileInternal(String deviceId) {
        boolean found = false;
        for (DeviceProfile deviceProfile : this.deviceProfiles) {
            if (!Value.isEqual(deviceProfile.getDeviceId(), deviceId)) continue;
            found = true;
            this.activeProfile = deviceProfile;
        }
        return found;
    }

    public final void setAllProfiles(List<DeviceProfile> profiles) {
        this.deviceProfiles.clear();
        this.deviceProfiles.addAll(profiles);
        String deviceId = this.activeProfile == null ? null : this.activeProfile.getDeviceId();
        boolean found = this.setActiveProfileInternal(deviceId);
        if (!found) {
            this.activeProfile = null;
        }
    }

    public final List<DeviceProfile> getAllProfiles() {
        return new ArrayList<DeviceProfile>(this.deviceProfiles);
    }

    public final void addProfile(DeviceProfile profile, boolean makeActive) {
        this.addProfileInternal(profile, makeActive);
    }

    public final void addProfile(DeviceProfile profile) {
        this.addProfileInternal(profile, false);
    }

    private void addProfileInternal(DeviceProfile profile, boolean makeActive) {
        if (profile != null) {
            this.deviceProfiles.add(profile);
            if (makeActive) {
                this.setActiveProfileInternal(profile.getDeviceId());
            }
        }
    }

    private DeviceProfile getProfileInternal(String deviceId) {
        DeviceProfile deviceProfile = null;
        for (DeviceProfile deviceProfileIt : this.deviceProfiles) {
            if (!Value.isEqual(deviceProfileIt.getDeviceId(), deviceId)) continue;
            deviceProfile = deviceProfileIt;
            break;
        }
        return deviceProfile;
    }

    public final boolean removeProfile(String deviceId) {
        DeviceProfile deviceProfileToRemove = null;
        for (DeviceProfile deviceProfile : this.deviceProfiles) {
            if (!deviceProfile.getDeviceId().equals(deviceId)) continue;
            deviceProfileToRemove = deviceProfile;
        }
        return this.deviceProfiles.remove(deviceProfileToRemove);
    }

    public final void updateProfileFromKNS(String deviceId, String knsUrl) throws IonicException {
        DeviceProfile deviceProfile = Value.isEmpty(deviceId) ? this.activeProfile : this.getProfileInternal(deviceId);
        SdkData.checkTrue(deviceProfile != null, 40022);
        String keySpace = deviceProfile.getKeySpace();
        SdkData.checkTrue(keySpace != null, 40004);
        String knsUrlCall = Value.isEmpty(knsUrl) ? "https://api.ionic.com" : knsUrl;
        GetKeyspaceResponse response = this.getKeyspaceInternal(new GetKeyspaceRequest(keySpace, knsUrlCall));
        List<String> apiURLs = response.getApiURLs();
        deviceProfile.setServer(apiURLs.isEmpty() ? new String(deviceProfile.getServer().toCharArray()) : apiURLs.iterator().next());
    }

    public final void loadProfiles() throws IonicException {
        throw new IonicException(40022);
    }

    public final void loadProfiles(ProfilePersistor persistor) throws IonicException {
        this.loadProfilesInternal(persistor);
    }

    private void loadProfilesInternal(ProfilePersistor persistor) throws IonicException {
        ArrayList<DeviceProfile> deviceProfilesInit;
        String[] activeProfileParam;
        block2: {
            activeProfileParam = new String[1];
            deviceProfilesInit = new ArrayList<DeviceProfile>();
            try {
                deviceProfilesInit = persistor == null ? new ArrayList() : persistor.loadAllProfiles(activeProfileParam);
            }
            catch (IonicException e) {
                if (e.getReturnCode() == 40023) break block2;
                throw e;
            }
        }
        this.loadProfilesInternal(deviceProfilesInit, activeProfileParam[0]);
    }

    private void loadProfilesInternal(List<DeviceProfile> deviceProfiles, String activeProfileId) throws IonicException {
        for (DeviceProfile deviceProfile : deviceProfiles) {
            try {
                deviceProfile.isValid();
            }
            catch (IonicException e) {
                throw new IonicException(40029, (Throwable)e);
            }
        }
        this.deviceProfiles = deviceProfiles;
        this.setActiveProfileInternal(activeProfileId);
    }

    public final void saveProfiles() throws IonicException {
        throw new IonicException(40022);
    }

    public final void saveProfiles(ProfilePersistor persistor) throws IonicException {
        String activeDeviceId = this.activeProfile == null ? null : this.activeProfile.getDeviceId();
        persistor.saveAllProfiles(this.deviceProfiles, activeDeviceId);
    }

    public final DeviceProfile getDeviceProfileForKeyId(String keyId) {
        return this.getDeviceProfileForKeyIdInternal(keyId);
    }

    private DeviceProfile getDeviceProfileForKeyIdInternal(String keyId) {
        boolean autoProfile = Boolean.parseBoolean(this.agentConfig.getProperty("autoselectprofile", Boolean.TRUE.toString()));
        boolean disableAutoProfile = Value.isEmpty(keyId);
        return autoProfile && !disableAutoProfile ? AgentTransactionUtil.getProfileForKeyId(this.deviceProfiles, keyId) : this.activeProfile;
    }

    public final GetKeyspaceResponse getKeyspace(GetKeyspaceRequest request) throws IonicException {
        return this.getKeyspaceInternal(request);
    }

    public final GetKeyspaceResponse getKeyspace(String keyspace) throws IonicException {
        return this.getKeyspaceInternal(new GetKeyspaceRequest(keyspace));
    }

    public final GetKeyspaceResponse getKeyspace(String keyspace, String url) throws IonicException {
        return this.getKeyspaceInternal(new GetKeyspaceRequest(keyspace, url));
    }

    private GetKeyspaceResponse getKeyspaceInternal(GetKeyspaceRequest request) throws IonicException {
        GetKeyspaceResponse response = new GetKeyspaceResponse();
        GetKeyspaceTransaction transaction = new GetKeyspaceTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        return response;
    }

    public final CreateDeviceResponse createDevice(CreateDeviceRequest request) throws IonicException {
        CreateDeviceResponse response = new CreateDeviceResponse();
        CreateDeviceTransaction transaction = new CreateDeviceTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        this.addProfileInternal(response.getDeviceProfile(), true);
        return response;
    }

    public final CreateDeviceResponse createDevice(CreateDeviceRequest request, boolean makeDeviceActive) throws IonicException {
        CreateDeviceResponse response = new CreateDeviceResponse();
        CreateDeviceTransaction transaction = new CreateDeviceTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        this.addProfileInternal(response.getDeviceProfile(), makeDeviceActive);
        return response;
    }

    @Override
    public final CreateKeysResponse createKeys(CreateKeysRequest request) throws IonicException {
        return this.createKeysInternal(request, new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey(KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, MetadataMap metadata) throws IonicException {
        return this.createKeyInternal(attributes, mutableAttributes, metadata, new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey(KeyAttributesMap attributes, KeyAttributesMap mutableAttributes) throws IonicException {
        return this.createKeyInternal(attributes, mutableAttributes, new MetadataMap(), new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey(KeyAttributesMap attributes, MetadataMap metadata) throws IonicException {
        return this.createKeyInternal(attributes, new KeyAttributesMap(), metadata, new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey(KeyAttributesMap attributes) throws IonicException {
        return this.createKeyInternal(attributes, new KeyAttributesMap(), new MetadataMap(), new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey(MetadataMap metadata) throws IonicException {
        return this.createKeyInternal(new KeyAttributesMap(), new KeyAttributesMap(), metadata, new VbeProtocol(this));
    }

    @Override
    public final CreateKeysResponse createKey() throws IonicException {
        return this.createKeyInternal(new KeyAttributesMap(), new KeyAttributesMap(), new MetadataMap(), new VbeProtocol(this));
    }

    protected CreateKeysResponse createKeysInternal(CreateKeysRequest request, ServiceProtocol protocol) throws IonicException {
        CreateKeysResponse response = new CreateKeysResponse();
        CreateKeysTransaction transaction = new CreateKeysTransaction(protocol, request, response);
        transaction.run();
        return response;
    }

    protected CreateKeysResponse createKeyInternal(KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, MetadataMap metadata, ServiceProtocol protocol) throws IonicException {
        CreateKeysRequest request = new CreateKeysRequest();
        request.setMetadata(metadata);
        request.add(new CreateKeysRequest.Key("ref", 1, attributes, mutableAttributes));
        CreateKeysResponse response = new CreateKeysResponse();
        CreateKeysTransaction transaction = new CreateKeysTransaction(protocol, request, response);
        transaction.run();
        if (response.getKeys().isEmpty()) {
            throw new IonicException(40024, (Throwable)new IonicServerException(40004, response.getConversationId(), response));
        }
        return response;
    }

    @Override
    public final GetKeysResponse getKeys(GetKeysRequest request) throws IonicException {
        String firstKeyId = request.getKeyIds().isEmpty() ? "" : request.getKeyIds().iterator().next();
        return this.getKeysInternal(request, new VbeProtocol(this, this.getDeviceProfileForKeyIdInternal(firstKeyId)));
    }

    @Override
    public final GetKeysResponse getKey(String keyId, MetadataMap metadata) throws IonicException {
        return this.getKeyInternal(keyId, metadata, new VbeProtocol(this, this.getDeviceProfileForKeyIdInternal(keyId)));
    }

    @Override
    public final GetKeysResponse getKey(String keyId) throws IonicException {
        return this.getKeyInternal(keyId, new MetadataMap(), new VbeProtocol(this, this.getDeviceProfileForKeyIdInternal(keyId)));
    }

    protected GetKeysResponse getKeysInternal(GetKeysRequest request, ServiceProtocol protocol) throws IonicException {
        GetKeysResponse response = new GetKeysResponse();
        GetKeysTransaction transaction = new GetKeysTransaction(protocol, request, response);
        transaction.run();
        return response;
    }

    protected GetKeysResponse getKeyInternal(String keyId, MetadataMap metadata, ServiceProtocol protocol) throws IonicException {
        GetKeysRequest request = new GetKeysRequest();
        request.setMetadata(metadata);
        request.add(keyId);
        GetKeysResponse response = new GetKeysResponse();
        GetKeysTransaction transaction = new GetKeysTransaction(protocol, request, response);
        transaction.run();
        if (response.getKeys().isEmpty()) {
            throw new IonicException(40024, (Throwable)new IonicServerException(40004, response.getConversationId(), response));
        }
        return response;
    }

    private UpdateKeysResponse updateKeysInternal(UpdateKeysRequest request) throws IonicException {
        UpdateKeysResponse response = new UpdateKeysResponse();
        UpdateKeysTransaction transaction = new UpdateKeysTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        return response;
    }

    @Override
    public final UpdateKeysResponse updateKeys(UpdateKeysRequest request) throws IonicException {
        return this.updateKeysInternal(request);
    }

    @Override
    public final UpdateKeysResponse updateKey(UpdateKeysRequest.Key key, MetadataMap metadata) throws IonicException {
        UpdateKeysRequest request = new UpdateKeysRequest();
        request.setMetadata(metadata);
        request.addKey(new UpdateKeysRequest.Key(key));
        return this.updateKeysInternal(request);
    }

    public final UpdateKeysResponse updateKey(UpdateKeysRequest.Key key) throws IonicException {
        UpdateKeysRequest request = new UpdateKeysRequest();
        request.addKey(new UpdateKeysRequest.Key(key));
        return this.updateKeysInternal(request);
    }

    public final GetResourcesResponse getResource(GetResourcesRequest.Resource resource) throws IonicException {
        GetResourcesRequest request = new GetResourcesRequest();
        request.setMetadata(this.getMetadata());
        request.add(resource);
        return this.getResourcesInternal(request);
    }

    public final GetResourcesResponse getResources(GetResourcesRequest request) throws IonicException {
        return this.getResourcesInternal(request);
    }

    private GetResourcesResponse getResourcesInternal(GetResourcesRequest request) throws IonicException {
        GetResourcesResponse response = new GetResourcesResponse();
        GetResourcesTransaction transaction = new GetResourcesTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        return response;
    }

    public final LogMessagesResponse logMessages(LogMessagesRequest request) throws IonicException {
        return this.logMessageInternal(request);
    }

    public final LogMessagesResponse logMessage(LogMessagesRequest.Message message, MetadataMap metadata) throws IonicException {
        LogMessagesRequest request = new LogMessagesRequest();
        request.setMetadata(metadata);
        request.add(message);
        return this.logMessageInternal(request);
    }

    public final LogMessagesResponse logMessage(LogMessagesRequest.Message message) throws IonicException {
        LogMessagesRequest request = new LogMessagesRequest();
        request.add(message);
        return this.logMessageInternal(request);
    }

    private LogMessagesResponse logMessageInternal(LogMessagesRequest request) throws IonicException {
        LogMessagesResponse response = new LogMessagesResponse();
        LogMessagesTransaction transaction = new LogMessagesTransaction(new VbeProtocol(this), request, response);
        transaction.run();
        return response;
    }

    public final void initialize() throws IonicException {
        throw new IonicException(40022);
    }

    public final void initialize(AgentConfig agentConfig) throws IonicException {
        throw new IonicException(40022);
    }

    public final void initialize(ProfilePersistor persistor) throws IonicException {
        this.initializeInternal(this.agentConfig, persistor, new MetadataMap(), new Fingerprint(null));
    }

    public final void initialize(AgentConfig agentConfig, ProfilePersistor persistor) throws IonicException {
        this.initializeInternal(agentConfig, persistor, new MetadataMap(), new Fingerprint(null));
    }

    public final void initializeWithoutProfiles() throws IonicException {
        this.initializeWithoutProfilesInternal(this.agentConfig);
    }

    public final void initializeWithoutProfiles(AgentConfig agentConfig) throws IonicException {
        this.initializeWithoutProfilesInternal(agentConfig);
    }

    private void initializeWithoutProfilesInternal(AgentConfig agentConfig) throws IonicException {
        this.initializeInternal(agentConfig, (ProfilePersistor)null, new MetadataMap(), new Fingerprint(null));
    }

    private void initializeInternal(AgentConfig agentConfig, ProfilePersistor persistor, MetadataMap metadata, Fingerprint fingerprint) throws IonicException {
        if (this.initialized) {
            throw new IonicException(40007);
        }
        AgentSdk.initialize();
        this.loadProfilesInternal(persistor);
        this.initialized = true;
        this.agentConfig = agentConfig;
        this.setMetadata(metadata);
        this.setMetadata("ionic-agent", SdkVersion.getAgentString());
        this.fingerprint = fingerprint;
    }

    private void initializeInternal(AgentConfig agentConfig, DeviceProfiles deviceProfiles, MetadataMap metadata, Fingerprint fingerprint) throws IonicException {
        if (this.initialized) {
            throw new IonicException(40007);
        }
        AgentSdk.initialize();
        this.loadProfilesInternal(deviceProfiles.getProfiles(), deviceProfiles.getActiveProfileId());
        this.initialized = true;
        this.agentConfig = agentConfig;
        this.setMetadata(metadata);
        this.setMetadata("ionic-agent", SdkVersion.getAgentString());
        this.fingerprint = fingerprint;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public static void calibrateServerTimeOffsetMillis(long serverTimeMillis) {
        long deviceTimeMillis = System.currentTimeMillis();
        serverTimeOffsetMillis = serverTimeMillis - deviceTimeMillis;
    }

    public static long getServerTimeUtcSecs() {
        return (System.currentTimeMillis() + serverTimeOffsetMillis) / 1000L;
    }

    public static long getServerTimeUtcMillis() {
        long deviceTimeMillis = System.currentTimeMillis();
        return deviceTimeMillis + serverTimeOffsetMillis;
    }

    public static long getServerTimeOffsetMillis() {
        return serverTimeOffsetMillis;
    }

    @Deprecated
    public static Agent clone(Agent agent) {
        Agent agentClone = new Agent();
        agentClone.initialized = agent.initialized;
        agentClone.deviceProfiles = new ArrayList<DeviceProfile>(agent.deviceProfiles);
        agentClone.activeProfile = agent.activeProfile;
        agentClone.agentConfig = new AgentConfig(agent.getConfig());
        agentClone.fingerprint = agent.fingerprint;
        agentClone.setMetadata(agent.getMetadata());
        return agentClone;
    }
}

