/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent;

import com.ionic.sdk.crypto.jce.CryptoAbstract;
import com.ionic.sdk.error.IonicException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class AgentSdk {
    private final IonicException exceptionInitialize;
    private final CryptoAbstract cryptoAbstract;
    private static final String DELIMITER_AT = "@";
    private static final String PROVIDER_SUNJCE = "SunJCE";

    private AgentSdk(Provider provider) {
        Logger logger = Logger.getLogger(AgentSdk.class.getName());
        CryptoAbstract cryptoAbstractCtor = null;
        IonicException exception = null;
        try {
            if (provider != null) {
                Security.addProvider(provider);
            }
            Provider providerUse = provider == null ? Security.getProvider(PROVIDER_SUNJCE) : provider;
            cryptoAbstractCtor = new CryptoAbstract(providerUse);
            AgentSdk.checkForUnlimitedStrength();
            logger.log(Level.FINE, "initialize() = OK");
        }
        catch (IonicException e) {
            exception = e;
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.exceptionInitialize = exception;
        this.cryptoAbstract = cryptoAbstractCtor;
    }

    private CryptoAbstract getCryptoAbstract() {
        return this.cryptoAbstract;
    }

    public static CryptoAbstract getCrypto() throws IonicException {
        AgentSdk agentSdk = SingletonHelper.getInstance();
        IonicException exceptionInitialize = agentSdk.exceptionInitialize;
        if (exceptionInitialize == null) {
            return agentSdk.getCryptoAbstract();
        }
        throw exceptionInitialize;
    }

    public static AgentSdk initialize(Object applicationContext) throws IonicException {
        AgentSdk agentSdk = SingletonHelper.getInstance();
        IonicException exceptionInitialize = agentSdk.exceptionInitialize;
        if (exceptionInitialize == null) {
            return agentSdk;
        }
        throw exceptionInitialize;
    }

    public static AgentSdk initialize(Provider provider) throws IonicException {
        AgentSdk agentSdk = SingletonHelper.initialize(provider);
        IonicException exceptionInitialize = agentSdk.exceptionInitialize;
        if (exceptionInitialize == null) {
            return agentSdk;
        }
        throw exceptionInitialize;
    }

    public static void deinitialize() {
        SingletonHelper.deinitialize();
    }

    public static void initialize() throws IonicException {
        AgentSdk agentSdk = SingletonHelper.getInstance();
        IonicException exceptionInitialize = agentSdk.exceptionInitialize;
        if (exceptionInitialize != null) {
            throw exceptionInitialize;
        }
    }

    public String toString() {
        return this.getClass().getName() + DELIMITER_AT + Integer.toHexString(this.hashCode());
    }

    private static void checkForUnlimitedStrength() throws IonicException {
        try {
            byte[] bytes = new byte[32];
            Arrays.fill(bytes, (byte)0);
            SecretKeySpec secretKeySpec = new SecretKeySpec(bytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, secretKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(42001, (Throwable)e);
        }
    }

    private static class SingletonHelper {
        private static volatile AgentSdk instance;

        private SingletonHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static AgentSdk getInstance() {
            if (instance != null) return instance;
            Class<SingletonHelper> clazz = SingletonHelper.class;
            synchronized (SingletonHelper.class) {
                if (instance != null) return instance;
                instance = new AgentSdk(null);
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static AgentSdk initialize(Provider provider) {
            if (instance != null) return instance;
            Class<SingletonHelper> clazz = SingletonHelper.class;
            synchronized (SingletonHelper.class) {
                if (instance != null) return instance;
                instance = new AgentSdk(provider);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private static void deinitialize() {
            instance = null;
        }
    }
}

