/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent;

import com.ionic.sdk.agent.Agent;
import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.data.MetadataMap;
import com.ionic.sdk.agent.hfp.Fingerprint;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.hash.Hash;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.IonicServerException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;

public final class VbeProtocol
implements ServiceProtocol {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Agent agent;
    private DeviceProfile deviceProfile;

    public VbeProtocol(Agent agent) {
        this(agent, agent.hasActiveProfile() ? agent.getActiveProfile() : new DeviceProfile());
    }

    public VbeProtocol(Agent agent, DeviceProfile deviceProfile) {
        this.agent = agent;
        this.deviceProfile = deviceProfile;
    }

    @Override
    public boolean isInitialized() {
        return this.agent.isInitialized();
    }

    @Override
    public boolean hasIdentity() {
        return this.deviceProfile != null;
    }

    @Override
    public boolean isValidIdentity() throws IonicException {
        return this.deviceProfile.isValid();
    }

    @Override
    public String getIdentity() {
        return this.deviceProfile.getDeviceId();
    }

    @Override
    public AgentConfig getConfig() {
        return this.agent.getConfig();
    }

    @Override
    public void addHeader(HttpHeaders httpHeaders) {
    }

    @Override
    public Fingerprint getFingerprint() {
        return this.agent.getFingerprint();
    }

    @Override
    public String generateCid() throws IonicException {
        return AgentTransactionUtil.generateConversationId(this.deviceProfile, "2.4.0");
    }

    @Override
    public MetadataMap getMetadata() {
        return this.agent.getMetadata();
    }

    @Override
    public String protectAttributes(String authData, String plainText) throws IonicException {
        SdkData.checkTrue(this.deviceProfile.getAesCdEiProfileKey() != null, 40022);
        AesGcmCipher cipher = new AesGcmCipher();
        cipher.setKey(this.deviceProfile.getAesCdEiProfileKey());
        cipher.setAuthData(Transcoder.utf8().decode(authData));
        return cipher.encryptToBase64(plainText);
    }

    @Override
    public String unprotectAttributes(String authData, String cipherText, byte[] key) throws IonicException {
        AesGcmCipher cipher = new AesGcmCipher();
        cipher.setKey(key);
        cipher.setAuthData(Transcoder.utf8().decode(authData));
        return cipher.decryptBase64ToString(cipherText);
    }

    @Override
    public byte[] transformRequestPayload(byte[] payloadIn, String cid) throws IonicException {
        AesGcmCipher cipher = new AesGcmCipher();
        cipher.setKey(this.deviceProfile.getAesCdIdcProfileKey());
        cipher.setAuthData(Transcoder.utf8().decode(cid));
        String payloadInWrapped = cipher.encryptToBase64(payloadIn);
        JsonObject payload = Json.createObjectBuilder().add("cid", cid).add("envelope", payloadInWrapped).build();
        String payloadOut = JsonIO.write(payload, false);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(payloadOut);
        }
        return Transcoder.utf8().decode(payloadOut);
    }

    @Override
    public byte[] transformResponsePayload(byte[] payloadIn, String cidQ) throws IonicException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Transcoder.utf8().encode(payloadIn));
        }
        return cidQ == null ? payloadIn : this.transformResponsePayloadInternal(payloadIn, cidQ);
    }

    private byte[] transformResponsePayloadInternal(byte[] payloadIn, String cidQ) throws IonicException {
        JsonObject jsonSecure = JsonIO.readObject(payloadIn, Level.WARNING);
        String cid = JsonSource.getString(jsonSecure, "cid");
        String envelope = JsonSource.getString(jsonSecure, "envelope");
        try {
            AgentTransactionUtil.checkNotNull(cid, "cid", cid);
            AgentTransactionUtil.checkNotNull(envelope, "envelope", envelope);
            AgentTransactionUtil.checkEqual(cidQ, cidQ, cid);
        }
        catch (IonicException e) {
            throw new IonicException(e.getReturnCode(), e.getMessage(), new IonicServerException(40009, JsonIO.write(jsonSecure, false)));
        }
        AesGcmCipher cipher = new AesGcmCipher();
        cipher.setKey(this.deviceProfile.getAesCdIdcProfileKey());
        cipher.setAuthData(Transcoder.utf8().decode(cid));
        String payloadOut = cipher.decryptBase64ToString(envelope);
        return Transcoder.utf8().decode(payloadOut);
    }

    @Override
    public URL getUrl() throws IonicException {
        return AgentTransactionUtil.getProfileUrl(this.deviceProfile.getServer());
    }

    @Override
    public String getResource(String version, String operation) {
        return "/" + version + operation;
    }

    @Override
    public byte[] getKeyBytes(String keyHex, String authData) throws IonicException {
        AesGcmCipher cipherEi = new AesGcmCipher();
        cipherEi.setKey(this.deviceProfile.getAesCdEiProfileKey());
        cipherEi.setAuthData(Transcoder.utf8().decode(authData));
        return cipherEi.decrypt(Transcoder.hex().decode(keyHex));
    }

    @Override
    public String signAttributes(String cid, String refId, String extra, Properties sigs, String attrs, boolean areMutable) throws IonicException {
        SdkData.checkTrue(this.deviceProfile.getAesCdEiProfileKey() != null, 40022);
        AesGcmCipher cipher = new AesGcmCipher();
        cipher.setKey(this.deviceProfile.getAesCdEiProfileKey());
        String authData = areMutable ? Value.join(":", cid, "m", refId, extra) : Value.join(":", cid, refId, extra);
        cipher.setAuthData(Transcoder.utf8().decode(authData));
        byte[] plainText = new Hash().sha256(Transcoder.utf8().decode(attrs));
        String sig = cipher.encryptToBase64(plainText);
        sigs.put(refId, sig);
        return sig;
    }

    @Override
    public void verifySignature(String name, String sigExpected, String attrs, byte[] key) throws IonicException {
        if (sigExpected != null) {
            byte[] keyVerify = key == null ? this.deviceProfile.getAesCdEiProfileKey() : key;
            String sigActual = CryptoUtils.hmacSHA256Base64(Transcoder.utf8().decode(attrs), keyVerify);
            if (!sigExpected.equals(sigActual)) {
                throw new IonicException(40005, (Throwable)new GeneralSecurityException(String.format("%s:[%s]!=[%s]", name, sigExpected, sigActual)));
            }
        }
    }
}

