/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.batch;

import com.ionic.sdk.agent.cipher.batch.data.CipherTextItem;
import com.ionic.sdk.agent.cipher.batch.data.PlainTextItem;
import com.ionic.sdk.agent.cipher.data.DecryptAttributes;
import com.ionic.sdk.agent.cipher.data.EncryptAttributes;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.util.List;

public abstract class BatchCipherAbstract {
    private final KeyServices keyServices;
    public static final String IONIC_IVS = "ionic-ivs";
    public static final String IONIC_ATAGS = "ionic-atags";

    public final KeyServices getKeyServices() {
        return this.keyServices;
    }

    public BatchCipherAbstract(KeyServices keyServices) {
        this.keyServices = keyServices;
    }

    public abstract List<CipherTextItem> encrypt(EncryptAttributes var1, List<PlainTextItem> var2) throws IonicException;

    public abstract List<PlainTextItem> decrypt(String var1, DecryptAttributes var2, List<CipherTextItem> var3) throws IonicException;

    protected String getBatchAttribute(KeyAttributesMap keyAttributes, String key) throws IonicException {
        List<String> values = keyAttributes.get(key);
        SdkData.checkTrue(values != null, 40004);
        SdkData.checkTrue(1 == values.size(), 40005);
        return values.iterator().next();
    }
}

