/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.batch;

import com.ionic.sdk.agent.cipher.batch.BatchCipherAbstract;
import com.ionic.sdk.agent.cipher.batch.data.CipherTextItem;
import com.ionic.sdk.agent.cipher.batch.data.PlainTextItem;
import com.ionic.sdk.agent.cipher.batch.spec.BatchIvParameterSpec;
import com.ionic.sdk.agent.cipher.data.DecryptAttributes;
import com.ionic.sdk.agent.cipher.data.EncryptAttributes;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BatchCipherV1
extends BatchCipherAbstract {
    public BatchCipherV1(KeyServices keyServices) {
        super(keyServices);
    }

    @Override
    public List<CipherTextItem> encrypt(EncryptAttributes encryptAttributes, List<PlainTextItem> items) throws IonicException {
        ArrayList<CipherTextItem> cipherTextResults = new ArrayList<CipherTextItem>();
        KeyAttributesMap keyAttributes = encryptAttributes.getKeyAttributes();
        BatchIvParameterSpec batchParameterSpec = new BatchIvParameterSpec(items.size());
        keyAttributes.put("ionic-ivs", Collections.singletonList(batchParameterSpec.getIvData()));
        KeyServices keyServices = this.getKeyServices();
        CreateKeysResponse createKeysResponse = keyServices.createKey(keyAttributes, encryptAttributes.getMetadata());
        CreateKeysResponse.Key createKey = createKeysResponse.getFirstKey();
        encryptAttributes.setKeyResponse(createKey);
        AesCtrCipher cipher = new AesCtrCipher(createKey.getSecretKey());
        for (PlainTextItem item : items) {
            ByteBuffer cipherBuffer;
            ByteBuffer plainBuffer;
            int count;
            byte[] plainText = item.getData();
            byte[] cipherText = new byte[plainText.length];
            SdkData.checkTrue(cipherText.length == (count = cipher.encrypt(plainBuffer = ByteBuffer.wrap(plainText), cipherBuffer = ByteBuffer.wrap(cipherText), batchParameterSpec.next())), 40001);
            cipherTextResults.add(new CipherTextItem(cipherText));
        }
        return cipherTextResults;
    }

    @Override
    public List<PlainTextItem> decrypt(String keyId, DecryptAttributes decryptAttributes, List<CipherTextItem> items) throws IonicException {
        ArrayList<PlainTextItem> plainTextResults = new ArrayList<PlainTextItem>();
        KeyServices keyServices = this.getKeyServices();
        GetKeysResponse getKeysResponse = keyServices.getKey(keyId, decryptAttributes.getMetadata());
        GetKeysResponse.Key getKey = getKeysResponse.getFirstKey();
        decryptAttributes.setKeyResponse(getKey);
        String ivs = this.getBatchAttribute(decryptAttributes.getKeyAttributes(), "ionic-ivs");
        BatchIvParameterSpec batchParameterSpec = new BatchIvParameterSpec(ivs);
        AesCtrCipher cipher = new AesCtrCipher(getKey.getSecretKey());
        for (CipherTextItem item : items) {
            byte[] cipherText = item.getData();
            byte[] plainText = new byte[cipherText.length];
            ByteBuffer cipherBuffer = ByteBuffer.wrap(cipherText);
            ByteBuffer plainBuffer = ByteBuffer.wrap(plainText);
            int count = cipher.decrypt(plainBuffer, cipherBuffer, batchParameterSpec.next());
            SdkData.checkTrue(plainText.length == count, 40001);
            plainTextResults.add(new PlainTextItem(plainText));
        }
        return plainTextResults;
    }
}

