/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.batch;

import com.ionic.sdk.agent.cipher.batch.BatchCipherAbstract;
import com.ionic.sdk.agent.cipher.batch.data.CipherTextItem;
import com.ionic.sdk.agent.cipher.batch.data.PlainTextItem;
import com.ionic.sdk.agent.cipher.batch.spec.BatchGcmParameterSpec;
import com.ionic.sdk.agent.cipher.data.DecryptAttributes;
import com.ionic.sdk.agent.cipher.data.EncryptAttributes;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysRequest;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysResponse;
import com.ionic.sdk.cipher.aes.AesGcmCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class BatchCipherV2
extends BatchCipherAbstract {
    public BatchCipherV2(KeyServices keyServices) {
        super(keyServices);
    }

    @Override
    public List<CipherTextItem> encrypt(EncryptAttributes encryptAttributes, List<PlainTextItem> items) throws IonicException {
        ArrayList<CipherTextItem> cipherTextResults = new ArrayList<CipherTextItem>();
        KeyAttributesMap keyAttributes = encryptAttributes.getKeyAttributes();
        BatchGcmParameterSpec batchParameterSpec = new BatchGcmParameterSpec(items.size());
        keyAttributes.put("ionic-ivs", Collections.singletonList(batchParameterSpec.getIvData()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(items.size() * 16);
        KeyServices keyServices = this.getKeyServices();
        CreateKeysResponse createKeysResponse = keyServices.createKey(keyAttributes, encryptAttributes.getMetadata());
        CreateKeysResponse.Key createKey = createKeysResponse.getFirstKey();
        encryptAttributes.setKeyResponse(createKey);
        AesGcmCipher cipher = new AesGcmCipher(createKey.getSecretKey());
        cipher.setAuthData(Transcoder.utf8().decode(createKey.getId()));
        for (PlainTextItem item : items) {
            ByteBuffer cipherBuffer;
            ByteBuffer plainBuffer;
            int count;
            byte[] plainText = item.getData();
            byte[] cipherText = new byte[plainText.length + 16];
            SdkData.checkTrue(cipherText.length == (count = cipher.encrypt(plainBuffer = ByteBuffer.wrap(plainText), cipherBuffer = ByteBuffer.wrap(cipherText), batchParameterSpec.next())), 40001);
            cipherTextResults.add(new CipherTextItem(Arrays.copyOfRange(cipherText, 0, plainText.length)));
            bos.write(cipherText, plainText.length, 16);
        }
        UpdateKeysRequest updateKeysRequest = new UpdateKeysRequest();
        UpdateKeysRequest.Key updateKey = new UpdateKeysRequest.Key(createKey, false);
        KeyAttributesMap mutableAttributes = updateKey.getMutableAttributesMap();
        mutableAttributes.put("ionic-atags", Collections.singletonList(Transcoder.base64().encode(bos.toByteArray())));
        updateKeysRequest.addKey(updateKey);
        UpdateKeysResponse updateKeysResponse = keyServices.updateKeys(updateKeysRequest);
        SdkData.checkTrue(updateKeysResponse.getErrors().isEmpty(), 40009);
        return cipherTextResults;
    }

    @Override
    public List<PlainTextItem> decrypt(String keyId, DecryptAttributes decryptAttributes, List<CipherTextItem> items) throws IonicException {
        ArrayList<PlainTextItem> plainTextResults = new ArrayList<PlainTextItem>();
        KeyServices keyServices = this.getKeyServices();
        GetKeysResponse getKeysResponse = keyServices.getKey(keyId, decryptAttributes.getMetadata());
        GetKeysResponse.Key getKey = getKeysResponse.getFirstKey();
        decryptAttributes.setKeyResponse(getKey);
        String ivs = this.getBatchAttribute(decryptAttributes.getKeyAttributes(), "ionic-ivs");
        BatchGcmParameterSpec batchParameterSpec = new BatchGcmParameterSpec(ivs);
        String atags = this.getBatchAttribute(decryptAttributes.getMutableKeyAttributes(), "ionic-atags");
        ByteArrayInputStream isAtags = new ByteArrayInputStream(Transcoder.base64().decode(atags));
        AesGcmCipher cipher = new AesGcmCipher(getKey.getSecretKey());
        cipher.setAuthData(Transcoder.utf8().decode(getKey.getId()));
        for (CipherTextItem item : items) {
            byte[] cipherText = item.getData();
            byte[] cipherTextWithAtag = Arrays.copyOf(cipherText, cipherText.length + 16);
            int countAtag = isAtags.read(cipherTextWithAtag, cipherText.length, 16);
            SdkData.checkTrue(countAtag == 16, 40005);
            byte[] plainText = new byte[cipherText.length];
            ByteBuffer cipherBuffer = ByteBuffer.wrap(cipherTextWithAtag);
            ByteBuffer plainBuffer = ByteBuffer.wrap(plainText);
            int count = cipher.decrypt(plainBuffer, cipherBuffer, batchParameterSpec.next());
            SdkData.checkTrue(plainText.length == count, 40005);
            plainTextResults.add(new PlainTextItem(plainText));
        }
        return plainTextResults;
    }
}

