/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.batch.data;

import java.nio.ByteBuffer;
import java.util.Date;

public final class DataTypes {
    private DataTypes() {
    }

    public static byte[] toBytes(int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(value);
        return byteBuffer.array();
    }

    public static byte[] toBytes(long value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(value);
        return byteBuffer.array();
    }

    public static byte[] toBytes(Date value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(value.getTime());
        return byteBuffer.array();
    }

    public static byte[] toBytes(float value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putFloat(value);
        return byteBuffer.array();
    }

    public static byte[] toBytes(double value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putDouble(value);
        return byteBuffer.array();
    }

    public static int toInt(byte[] value) {
        return ByteBuffer.wrap(value).getInt();
    }

    public static long toLong(byte[] value) {
        return ByteBuffer.wrap(value).getLong();
    }

    public static Date toDate(byte[] value) {
        return new Date(ByteBuffer.wrap(value).getLong());
    }

    public static float toFloat(byte[] value) {
        return ByteBuffer.wrap(value).getFloat();
    }

    public static double toDouble(byte[] value) {
        return ByteBuffer.wrap(value).getDouble();
    }
}

