/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.batch.spec;

import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.error.IonicException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public abstract class AbstractBatchParameterSpec {
    private final byte[] ivData;
    private int index;

    public final String getIvData() {
        return Transcoder.base64().encode(this.ivData);
    }

    protected final byte[] getIvNext() {
        int offset = ++this.index * 16;
        return Arrays.copyOfRange(this.ivData, offset, offset + 16);
    }

    public AbstractBatchParameterSpec(int count) throws IonicException {
        this.ivData = new CryptoRng().rand(new byte[count * 16]);
        this.index = -1;
    }

    public AbstractBatchParameterSpec(String ivsB64) {
        this.ivData = Transcoder.base64().decode(ivsB64);
        this.index = -1;
    }

    public abstract AlgorithmParameterSpec next();
}

