/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.chunk;

import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoChunkInfo;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoEncryptAttributes;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.request.createkey.CreateKeysRequest;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.request.getkey.GetKeysRequest;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.key.KeyServices;
import java.util.Arrays;
import java.util.List;

public abstract class ChunkCipherAbstract {
    private final KeyServices agent;

    public final KeyServices getKeyServices() {
        return this.agent;
    }

    public ChunkCipherAbstract(KeyServices agent) {
        this.agent = agent;
    }

    final String encryptInternal(byte[] plainText, ChunkCryptoEncryptAttributes encryptAttributes) throws IonicException {
        List<CreateKeysResponse.Key> createKeys;
        if (Value.isEmpty(plainText)) {
            throw new IonicException(20007);
        }
        encryptAttributes.validateInput();
        CreateKeysRequest createKeysRequest = new CreateKeysRequest();
        String refId = this.getClass().getSimpleName();
        createKeysRequest.add(new CreateKeysRequest.Key(refId, 1, encryptAttributes.getKeyAttributes(), encryptAttributes.getMutableKeyAttributes()));
        createKeysRequest.setMetadata(encryptAttributes.getMetadata());
        CreateKeysResponse createKeysResponse = this.agent.createKeys(createKeysRequest);
        encryptAttributes.setCipherId(this.getId());
        if (createKeysResponse.getServerErrorCode() != 0) {
            encryptAttributes.setServerErrorResponse(createKeysResponse);
        }
        if ((createKeys = createKeysResponse.getKeys()).isEmpty()) {
            throw new IonicException(40024, SdkError.getErrorString(40024));
        }
        CreateKeysResponse.Key createKey = createKeys.iterator().next();
        createKey.setAttributesMap(encryptAttributes.getKeyAttributes());
        createKey.setMutableAttributesMap(encryptAttributes.getMutableKeyAttributes());
        encryptAttributes.setKeyResponse(createKey);
        String keyId = createKey.getId();
        String cipherText = this.normalize(this.encryptInternal(createKey, plainText));
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getDelimiterKeyTagStart()).append(keyId).append(this.getDelimiterCiphertextStart()).append(cipherText).append(this.getDelimiterCiphertextEnd());
        return buffer.toString();
    }

    final byte[] decryptInternal(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        String delimiterKeyTagStart = this.getDelimiterKeyTagStart();
        String delimiterCiphertextStart = this.getDelimiterCiphertextStart();
        String delimiterCiphertextEnd = this.getDelimiterCiphertextEnd();
        int keyTagDelimStart = cipherText.indexOf(delimiterKeyTagStart);
        int keyTagDelimEnd = keyTagDelimStart + delimiterKeyTagStart.length();
        int cipherTextDelimStart = cipherText.indexOf(delimiterCiphertextStart, keyTagDelimEnd);
        int cipherTextStart = cipherTextDelimStart + delimiterCiphertextStart.length();
        int cipherTextEnd = cipherText.indexOf(delimiterCiphertextEnd, cipherTextStart);
        int cipherTextDelimEnd = cipherTextEnd + delimiterCiphertextEnd.length();
        if (keyTagDelimStart >= 0 && cipherTextDelimStart > 0 && cipherTextDelimEnd > 0) {
            String keyId = cipherText.substring(keyTagDelimEnd, cipherTextDelimStart);
            String cipherTextBase64 = this.denormalize(cipherText.substring(cipherTextStart, cipherTextEnd));
            return this.decryptInternal(keyId, cipherTextBase64, decryptAttributes);
        }
        int errorCode = 40005;
        throw new IonicException(40005, (Throwable)new IonicException(40005, cipherText));
    }

    private byte[] decryptInternal(String keyIdQ, String cipherTextBase64, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        List<GetKeysResponse.Key> getKeys;
        decryptAttributes.validateInput();
        GetKeysRequest getKeysRequest = new GetKeysRequest();
        getKeysRequest.add(keyIdQ);
        getKeysRequest.setMetadata(decryptAttributes.getMetadata());
        GetKeysResponse getKeysResponse = this.agent.getKeys(getKeysRequest);
        decryptAttributes.setCipherId(this.getId());
        if (getKeysResponse.getServerErrorCode() != 0) {
            decryptAttributes.setServerErrorResponse(getKeysResponse);
        }
        if ((getKeys = getKeysResponse.getKeys()).isEmpty()) {
            int errorCode = 40024;
            throw new IonicException(40024, (Throwable)new IonicException(40024, cipherTextBase64));
        }
        GetKeysResponse.Key getKey = getKeys.iterator().next();
        decryptAttributes.setKeyResponse(getKey);
        String keyId = getKey.getId();
        if (!keyIdQ.equals(keyId)) {
            int errorCode = 40015;
            throw new IonicException(40015, (Throwable)new IonicException(40015, cipherTextBase64));
        }
        return this.decryptInternal(getKey, cipherTextBase64);
    }

    final ChunkCryptoChunkInfo getChunkInfoInternal(String data) {
        String delimKeyTagStart = this.getDelimiterKeyTagStart();
        String delimCiphertextStart = this.getDelimiterCiphertextStart();
        String delimCiphertextEnd = this.getDelimiterCiphertextEnd();
        String delimAll = delimKeyTagStart + delimCiphertextStart + delimCiphertextEnd;
        if (data == null) {
            return null;
        }
        if (data.length() < delimAll.length()) {
            return null;
        }
        if (!data.startsWith(delimKeyTagStart)) {
            return null;
        }
        if (!data.endsWith(delimCiphertextEnd)) {
            return null;
        }
        int indexOf = data.indexOf(delimCiphertextStart, delimKeyTagStart.length());
        if (indexOf < 0) {
            return null;
        }
        int cipherTextStart = indexOf + delimCiphertextStart.length();
        int cipherTextEnd = data.indexOf(delimCiphertextEnd, cipherTextStart);
        int keyIdLength = indexOf - delimKeyTagStart.length();
        int beginIndex = delimKeyTagStart.length();
        int endIndex = beginIndex + keyIdLength;
        String keyId = data.substring(beginIndex, endIndex);
        return new ChunkCryptoChunkInfo(true, keyId, this.getId(), cipherTextStart, cipherTextEnd - cipherTextStart);
    }

    public abstract String getId();

    public abstract String getLabel();

    protected abstract String getDelimiterKeyTagStart();

    protected abstract String getDelimiterCiphertextStart();

    protected abstract String getDelimiterCiphertextEnd();

    public abstract ChunkCryptoChunkInfo getChunkInfo(String var1);

    public abstract String encrypt(String var1) throws IonicException;

    public abstract String encrypt(String var1, ChunkCryptoEncryptAttributes var2) throws IonicException;

    public abstract String encrypt(byte[] var1) throws IonicException;

    public abstract String encrypt(byte[] var1, ChunkCryptoEncryptAttributes var2) throws IonicException;

    protected abstract String encryptInternal(AgentKey var1, byte[] var2) throws IonicException;

    public abstract String decrypt(String var1) throws IonicException;

    public abstract String decrypt(String var1, ChunkCryptoDecryptAttributes var2) throws IonicException;

    public abstract String decrypt(byte[] var1) throws IonicException;

    public abstract String decrypt(byte[] var1, ChunkCryptoDecryptAttributes var2) throws IonicException;

    public abstract byte[] decryptToBytes(String var1) throws IonicException;

    public abstract byte[] decryptToBytes(String var1, ChunkCryptoDecryptAttributes var2) throws IonicException;

    protected abstract byte[] decryptInternal(AgentKey var1, String var2) throws IonicException;

    private String normalize(String base64) {
        return base64.replace("=", "");
    }

    private String denormalize(String cipherText) {
        int base64BlockSize = 4;
        int lastBlockSize = cipherText.length() % 4;
        if (lastBlockSize == 0) {
            return cipherText;
        }
        char[] padding = new char[4 - lastBlockSize];
        Arrays.fill(padding, '=');
        return cipherText + new String(padding);
    }
}

