/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.chunk;

import com.ionic.sdk.agent.cipher.chunk.ChunkCipherAbstract;
import com.ionic.sdk.agent.cipher.chunk.ChunkCipherV1;
import com.ionic.sdk.agent.cipher.chunk.ChunkCipherV2;
import com.ionic.sdk.agent.cipher.chunk.ChunkCipherV3;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoChunkInfo;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoEncryptAttributes;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;

public class ChunkCipherAuto
extends ChunkCipherAbstract {
    private final ChunkCipherAbstract[] chunkCiphers;
    private final ChunkCipherAbstract chunkCipherDefault;
    public static final String ID = "ChunkAuto";

    public ChunkCipherAuto(KeyServices agent) {
        super(agent);
        ChunkCipherV1 chunkCipherV1 = new ChunkCipherV1(agent);
        ChunkCipherV2 chunkCipherV2 = new ChunkCipherV2(agent);
        ChunkCipherV3 chunkCipherV3 = new ChunkCipherV3(agent);
        this.chunkCiphers = new ChunkCipherAbstract[]{chunkCipherV1, chunkCipherV2, chunkCipherV3};
        this.chunkCipherDefault = chunkCipherV2;
    }

    @Override
    public final String getId() {
        return ID;
    }

    @Override
    public final String getLabel() {
        return ID;
    }

    @Override
    public final String encrypt(String plainText) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText), new ChunkCryptoEncryptAttributes());
    }

    @Override
    public final String encrypt(String plainText, ChunkCryptoEncryptAttributes encryptAttributes) throws IonicException {
        return this.chunkCipherDefault.encryptInternal(Transcoder.utf8().decode(plainText), encryptAttributes);
    }

    @Override
    public final String encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText, new ChunkCryptoEncryptAttributes());
    }

    @Override
    public final String encrypt(byte[] plainText, ChunkCryptoEncryptAttributes encryptAttributes) throws IonicException {
        return this.chunkCipherDefault.encryptInternal(plainText, encryptAttributes);
    }

    @Override
    protected final String encryptInternal(AgentKey key, byte[] plainText) throws IonicException {
        return this.chunkCipherDefault.encryptInternal(key, plainText);
    }

    @Override
    public final String decrypt(String cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptAuto(cipherText, new ChunkCryptoDecryptAttributes()));
    }

    @Override
    public final String decrypt(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return Transcoder.utf8().encode(this.decryptAuto(cipherText, decryptAttributes));
    }

    @Override
    public final String decrypt(byte[] cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptAuto(Transcoder.utf8().encode(cipherText), new ChunkCryptoDecryptAttributes()));
    }

    @Override
    public final String decrypt(byte[] cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return Transcoder.utf8().encode(this.decryptAuto(Transcoder.utf8().encode(cipherText), decryptAttributes));
    }

    @Override
    public final byte[] decryptToBytes(String cipherText) throws IonicException {
        return this.decryptAuto(cipherText, new ChunkCryptoDecryptAttributes());
    }

    @Override
    public final byte[] decryptToBytes(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return this.decryptAuto(cipherText, decryptAttributes);
    }

    private byte[] decryptAuto(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        ChunkCryptoChunkInfo chunkInfo = this.getChunkInfoAuto(cipherText);
        for (ChunkCipherAbstract chunkCipher : this.chunkCiphers) {
            if (!chunkInfo.getCipherId().equals(chunkCipher.getId())) continue;
            return chunkCipher.decryptToBytes(cipherText, decryptAttributes);
        }
        int errorCode = 40005;
        throw new IonicException(40005, (Throwable)new IonicException(40005, cipherText));
    }

    @Override
    protected final byte[] decryptInternal(AgentKey key, String cipherTextBase64) throws IonicException {
        int errorCode = 20001;
        throw new IonicException(20001, (Throwable)new IonicException(20001, cipherTextBase64));
    }

    @Override
    public final ChunkCryptoChunkInfo getChunkInfo(String data) {
        return this.getChunkInfoAuto(data);
    }

    private ChunkCryptoChunkInfo getChunkInfoAuto(String data) {
        ChunkCryptoChunkInfo chunkInfo = new ChunkCryptoChunkInfo();
        for (ChunkCipherAbstract chunkCipher : this.chunkCiphers) {
            ChunkCryptoChunkInfo chunkInfoIt = chunkCipher.getChunkInfoInternal(data);
            if (chunkInfoIt == null) continue;
            chunkInfo = chunkInfoIt;
            break;
        }
        return chunkInfo;
    }

    @Override
    protected final String getDelimiterCiphertextStart() {
        return this.chunkCipherDefault.getDelimiterCiphertextStart();
    }

    @Override
    protected final String getDelimiterCiphertextEnd() {
        return this.chunkCipherDefault.getDelimiterCiphertextEnd();
    }

    @Override
    protected final String getDelimiterKeyTagStart() {
        return this.chunkCipherDefault.getDelimiterKeyTagStart();
    }
}

