/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.chunk;

import com.ionic.sdk.agent.cipher.chunk.ChunkCipherAbstract;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoChunkInfo;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoDecryptAttributes;
import com.ionic.sdk.agent.cipher.chunk.data.ChunkCryptoEncryptAttributes;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.key.KeyServices;

public class ChunkCipherV1
extends ChunkCipherAbstract {
    public static final String ID = "ChunkV1";
    private static final String DELIMITER_CIPHERTEXT_START = "~fEc!";
    private static final String DELIMITER_CIPHERTEXT_END = "!cEf";
    private static final String DELIMITER_KEYTAG_START = "~!";

    public ChunkCipherV1(KeyServices agent) {
        super(agent);
    }

    @Override
    public final String getId() {
        return ID;
    }

    @Override
    public final String getLabel() {
        return ID;
    }

    @Override
    protected final String getDelimiterCiphertextStart() {
        return DELIMITER_CIPHERTEXT_START;
    }

    @Override
    protected final String getDelimiterCiphertextEnd() {
        return DELIMITER_CIPHERTEXT_END;
    }

    @Override
    protected final String getDelimiterKeyTagStart() {
        return DELIMITER_KEYTAG_START;
    }

    @Override
    public final ChunkCryptoChunkInfo getChunkInfo(String data) {
        return this.getChunkInfoInternal(data);
    }

    @Override
    public final String encrypt(String plainText) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText), new ChunkCryptoEncryptAttributes());
    }

    @Override
    public final String encrypt(String plainText, ChunkCryptoEncryptAttributes encryptAttributes) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText), encryptAttributes);
    }

    @Override
    public final String encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText, new ChunkCryptoEncryptAttributes());
    }

    @Override
    public final String encrypt(byte[] plainText, ChunkCryptoEncryptAttributes encryptAttributes) throws IonicException {
        return this.encryptInternal(plainText, encryptAttributes);
    }

    @Override
    protected final String encryptInternal(AgentKey key, byte[] plainText) throws IonicException {
        AesCtrCipher cipher = new AesCtrCipher();
        cipher.setKey(key.getKey());
        return cipher.encryptToBase64(plainText);
    }

    @Override
    public final String decrypt(String cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(cipherText, new ChunkCryptoDecryptAttributes()));
    }

    @Override
    public final String decrypt(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(cipherText, decryptAttributes));
    }

    @Override
    public final String decrypt(byte[] cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(Transcoder.utf8().encode(cipherText), new ChunkCryptoDecryptAttributes()));
    }

    @Override
    public final String decrypt(byte[] cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(Transcoder.utf8().encode(cipherText), decryptAttributes));
    }

    @Override
    public final byte[] decryptToBytes(String cipherText) throws IonicException {
        return this.decryptInternal(cipherText, new ChunkCryptoDecryptAttributes());
    }

    @Override
    public final byte[] decryptToBytes(String cipherText, ChunkCryptoDecryptAttributes decryptAttributes) throws IonicException {
        return this.decryptInternal(cipherText, decryptAttributes);
    }

    @Override
    protected final byte[] decryptInternal(AgentKey key, String cipherTextBase64) throws IonicException {
        AesCtrCipher cipher = new AesCtrCipher();
        cipher.setKey(key.getKey());
        return cipher.decryptBase64(cipherTextBase64);
    }
}

